/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarModel_skikoKt;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.SelectableDates;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b!\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Landroidx/compose/material3/BaseDatePickerStateImpl;", "", "initialDisplayedMonthMillis", "", "yearRange", "Lkotlin/ranges/IntRange;", "selectableDates", "Landroidx/compose/material3/SelectableDates;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/lang/Long;Lkotlin/ranges/IntRange;Landroidx/compose/material3/SelectableDates;Ljava/util/Locale;)V", "_displayedMonth", "Landroidx/compose/runtime/MutableState;", "Landroidx/compose/material3/CalendarMonth;", "calendarModel", "Landroidx/compose/material3/CalendarModel;", "getCalendarModel", "()Landroidx/compose/material3/CalendarModel;", "monthMillis", "displayedMonthMillis", "getDisplayedMonthMillis", "()J", "setDisplayedMonthMillis", "(J)V", "getSelectableDates", "()Landroidx/compose/material3/SelectableDates;", "getYearRange", "()Lkotlin/ranges/IntRange;", "material3"})
@Stable
public abstract class BaseDatePickerStateImpl {
    @NotNull
    private final IntRange yearRange;
    @NotNull
    private final SelectableDates selectableDates;
    @NotNull
    private final CalendarModel calendarModel;
    @NotNull
    private MutableState<CalendarMonth> _displayedMonth;
    public static final int $stable;

    public BaseDatePickerStateImpl(@Nullable Long initialDisplayedMonthMillis, @NotNull IntRange yearRange, @NotNull SelectableDates selectableDates, @NotNull Locale locale) {
        CalendarMonth calendarMonth;
        Intrinsics.checkNotNullParameter((Object)yearRange, (String)"yearRange");
        Intrinsics.checkNotNullParameter((Object)selectableDates, (String)"selectableDates");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.yearRange = yearRange;
        this.selectableDates = selectableDates;
        this.calendarModel = CalendarModel_skikoKt.createCalendarModel(locale);
        if (initialDisplayedMonthMillis != null) {
            CalendarMonth month = this.calendarModel.getMonth(initialDisplayedMonthMillis);
            if (!this.yearRange.contains(month.getYear())) {
                BaseDatePickerStateImpl baseDatePickerStateImpl = this;
                boolean bl = false;
                BaseDatePickerStateImpl baseDatePickerStateImpl2 = baseDatePickerStateImpl;
                String string = "The initial display month's year (" + month.getYear() + ") is out of the years range of " + this.yearRange + '.';
                throw new IllegalArgumentException(string.toString());
            }
            calendarMonth = month;
        } else {
            calendarMonth = this.calendarModel.getMonth(this.calendarModel.getToday());
        }
        this._displayedMonth = SnapshotStateKt.mutableStateOf$default((Object)calendarMonth, null, (int)2, null);
    }

    @NotNull
    public final IntRange getYearRange() {
        return this.yearRange;
    }

    @NotNull
    public final SelectableDates getSelectableDates() {
        return this.selectableDates;
    }

    @NotNull
    public final CalendarModel getCalendarModel() {
        return this.calendarModel;
    }

    public final long getDisplayedMonthMillis() {
        return ((CalendarMonth)this._displayedMonth.getValue()).getStartUtcTimeMillis();
    }

    public final void setDisplayedMonthMillis(long monthMillis) {
        CalendarMonth month = this.calendarModel.getMonth(monthMillis);
        if (!this.yearRange.contains(month.getYear())) {
            boolean bl = false;
            String string = "The display month's year (" + month.getYear() + ") is out of the years range of " + this.yearRange + '.';
            throw new IllegalArgumentException(string.toString());
        }
        this._displayedMonth.setValue((Object)month);
    }
}

