/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.te() = mapOf(
    Strings.NavigationMenu to "నావిగేషన్ మెనూ",
    Strings.ExposedDropdownMenu to "డ్రాప్‌డౌన్ మెనూ",
    Strings.CloseDrawer to "నావిగేషన్ మెనూను మూసివేయి",
    Strings.CloseSheet to "షీట్‌ను మూసివేయి",
    Strings.DefaultErrorMessage to "ఇన్‌పుట్ చెల్లదు",
    Strings.SliderRangeStart to "పరిధి ప్రారంభమయింది",
    Strings.SliderRangeEnd to "పరిధి ముగిసింది",
    Strings.Dialog to "డైలాగ్",
    Strings.MenuExpanded to "విస్తరించబడింది",
    Strings.MenuCollapsed to "కుదించబడింది",
    Strings.SnackbarDismiss to "విస్మరించండి",
    Strings.SearchBarSearch to "సెర్చ్ చేయండి",
    Strings.SuggestionsAvailable to "సూచనలు దిగువున ఉన్నాయి",
    Strings.DatePickerTitle to "తేదీని ఎంచుకోండి",
    Strings.DatePickerHeadline to "ఎంచుకున్న తేదీ",
    Strings.DatePickerSwitchToYearSelection to "సంవత్సరాన్ని ఎంచుకునే ఆప్షన్‌కు మారండి",
    Strings.DatePickerSwitchToDaySelection to "సంవత్సరాన్ని ఎంచుకోవడానికి స్వైప్ చేయండి, లేదా తిరిగి రోజును ఎంచుకునేందుకు మారడానికి ట్యాప్ చేయండి",
    Strings.DatePickerSwitchToNextMonth to "వచ్చే నెలకు మార్చండి",
    Strings.DatePickerSwitchToPreviousMonth to "మునుపటి నెలకు మార్చండి",
    Strings.DatePickerNavigateToYearDescription to "%1\$s సంవత్సరానికి వెళ్లండి",
    Strings.DatePickerHeadlineDescription to "ప్రస్తుత ఎంపిక: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ఏదీ లేదు",
    Strings.DatePickerTodayDescription to "నేడు",
    Strings.DatePickerYearPickerPaneTitle to "సంవత్సరం పికర్ కనిపిస్తుంది",
    Strings.DateInputTitle to "తేదీని ఎంచుకోండి",
    Strings.DateInputHeadline to "ఎంటర్ చేసిన తేదీ",
    Strings.DateInputLabel to "తేదీ",
    Strings.DateInputHeadlineDescription to "ఎంటర్ చేసిన తేదీ: %1\$s",
    Strings.DateInputNoInputDescription to "ఏదీ లేదు",
    Strings.DateInputInvalidNotAllowed to "చెల్లని తేదీ: %1\$s",
    Strings.DateInputInvalidForPattern to "తేదీ, ఉండాల్సిన ఫార్మాట్‌తో మ్యాచ్ కాలేదు: %1\$s",
    Strings.DateInputInvalidYearRange to "ఉండాల్సిన సంవత్సరాల పరిధి %1\$s - %2\$s‌లో తేదీ లేదు",
    Strings.DatePickerSwitchToCalendarMode to "క్యాలెండర్ ఇన్‌పుట్ మోడ్‌కు మారండి",
    Strings.DatePickerSwitchToInputMode to "టెక్స్ట్ ఇన్‌పుట్ మోడ్‌కు మారండి",
    Strings.DatePickerScrollToShowLaterYears to "తర్వాతి సంవత్సరాల డేటాను చూడటానికి స్క్రోల్ చేయండి",
    Strings.DatePickerScrollToShowEarlierYears to "మునుపటి సంవత్సరాల డేటాను చూడటానికి స్క్రోల్ చేయండి",
    Strings.DateRangePickerTitle to "తేదీలను ఎంచుకోండి",
    Strings.DateRangePickerStartHeadline to "ప్రారంభ తేదీ",
    Strings.DateRangePickerEndHeadline to "ముగింపు తేదీ",
    Strings.DateRangePickerScrollToShowNextMonth to "వచ్చే నెల డేటాను చూడటానికి స్క్రోల్ చేయండి",
    Strings.DateRangePickerScrollToShowPreviousMonth to "మునుపటి నెల డేటాను చూడటానికి స్క్రోల్ చేయండి",
    Strings.DateRangePickerDayInRange to "పరిధిలో ఉంది",
    Strings.DateRangeInputTitle to "తేదీలను ఎంటర్ చేయండి",
    Strings.DateRangeInputInvalidRangeInput to "తేదీల పరిధి ఇన్‌పుట్ చెల్లదు",
    Strings.BottomSheetPaneTitle to "దిగువున ఉన్న షీట్",
    Strings.BottomSheetDragHandleDescription to "లాగే హ్యాండిల్",
    Strings.BottomSheetPartialExpandDescription to "దిగువున ఉన్న షీట్‌ను కుదిస్తుంది",
    Strings.BottomSheetDismissDescription to "దిగువున ఉన్న షీట్‌ను విస్మరిస్తుంది",
    Strings.BottomSheetExpandDescription to "దిగువున ఉన్న షీట్‌ను విస్తరిస్తుంది",
    Strings.TooltipPaneDescription to "టూల్‌టిప్",
    Strings.TooltipLongPressLabel to "టూల్‌టిప్‌ను చూడండి",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM లేదా PMను ఎంచుకోండి",
    Strings.TimePickerHourSelection to "గంటలను ఎంచుకోవడానికి వీలు కల్పిస్తుంది",
    Strings.TimePickerMinuteSelection to "నిమిషాలను ఎంచుకోండి",
    Strings.TimePickerHourSuffix to "%1\$d గం",
    Strings.TimePicker24HourSuffix to "%1\$d గంటలు",
    Strings.TimePickerMinuteSuffix to "%1\$d నిమిషాలు",
    Strings.TimePickerMinute to "నిమిషం",
    Strings.TimePickerHour to "గంట",
    Strings.TimePickerMinuteTextField to "నిమిషాలను ఎంచుకోవడం కోసం",
    Strings.TimePickerHourTextField to "గంటలను ఎంచుకోవడం కోసం",
)
