/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ta() = mapOf(
    Strings.NavigationMenu to "வழிசெலுத்தல் மெனு",
    Strings.ExposedDropdownMenu to "கீழ்த்தோன்றல் மெனு",
    Strings.CloseDrawer to "வழிசெலுத்தல் மெனுவை மூடும்",
    Strings.CloseSheet to "ஷீட்டை மூடும்",
    Strings.DefaultErrorMessage to "தவறான உள்ளீடு",
    Strings.SliderRangeStart to "வரம்பு தொடக்கம்",
    Strings.SliderRangeEnd to "வரம்பு முடிவு",
    Strings.Dialog to "உரையாடல்",
    Strings.MenuExpanded to "விரிவாக்கப்பட்டது",
    Strings.MenuCollapsed to "சுருக்கப்பட்டது",
    Strings.SnackbarDismiss to "நிராகரிக்கும்",
    Strings.SearchBarSearch to "தேடல்",
    Strings.SuggestionsAvailable to "பரிந்துரைகள் கீழே கிடைக்கும்",
    Strings.DatePickerTitle to "தேதியைத் தேர்வுசெய்க",
    Strings.DatePickerHeadline to "தேர்ந்தெடுக்கப்பட்ட தேதி",
    Strings.DatePickerSwitchToYearSelection to "ஆண்டைத் தேர்ந்தெடுக்கும் விருப்பத்திற்கு மாற்று",
    Strings.DatePickerSwitchToDaySelection to "ஆண்டைத் தேர்வுசெய்ய ஸ்வைப் செய்யுங்கள் அல்லது தேதியைத் தேர்வுசெய்யும் பக்கத்திற்கு மீண்டும் செல்ல தட்டுங்கள்",
    Strings.DatePickerSwitchToNextMonth to "அடுத்த மாதத்திற்கு மாற்று",
    Strings.DatePickerSwitchToPreviousMonth to "முந்தைய மாதத்திற்கு மாற்று",
    Strings.DatePickerNavigateToYearDescription to "%1\$sக்குச் செல்லும்",
    Strings.DatePickerHeadlineDescription to "தற்போதைய தேர்வு: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ஏதுமில்லை",
    Strings.DatePickerTodayDescription to "இன்று",
    Strings.DatePickerYearPickerPaneTitle to "ஆண்டைத் தேர்வுசெய்யும் விருப்பம் காட்டப்படுகிறது",
    Strings.DateInputTitle to "தேதியைத் தேர்வுசெய்க",
    Strings.DateInputHeadline to "உள்ளிட்ட தேதி",
    Strings.DateInputLabel to "தேதி",
    Strings.DateInputHeadlineDescription to "உள்ளிட்ட தேதி: %1\$s",
    Strings.DateInputNoInputDescription to "ஏதுமில்லை",
    Strings.DateInputInvalidNotAllowed to "இந்தத் தேதி அனுமதிக்கப்படவில்லை: %1\$s",
    Strings.DateInputInvalidForPattern to "எதிர்பார்க்கப்படும் பேட்டர்னுடன் தேதி பொருந்தவில்லை: %1\$s",
    Strings.DateInputInvalidYearRange to "இந்தத் தேதி %1\$s - %2\$s ஆண்டு வரம்பிற்குள் இல்லை",
    Strings.DatePickerSwitchToCalendarMode to "கேலெண்டர் உள்ளீட்டு முறைக்கு மாற்று",
    Strings.DatePickerSwitchToInputMode to "எழுத்து உள்ளீட்டு முறைக்கு மாற்று",
    Strings.DatePickerScrollToShowLaterYears to "பிந்தைய ஆண்டுகளைப் பார்க்க ஸ்க்ரோல் செய்யுங்கள்",
    Strings.DatePickerScrollToShowEarlierYears to "முந்தைய ஆண்டுகளைப் பார்க்க ஸ்க்ரோல் செய்யுங்கள்",
    Strings.DateRangePickerTitle to "தேதிகளைத் தேர்ந்தெடுங்கள்",
    Strings.DateRangePickerStartHeadline to "தொடக்கத் தேதி",
    Strings.DateRangePickerEndHeadline to "முடிவுத் தேதி",
    Strings.DateRangePickerScrollToShowNextMonth to "அடுத்த மாதத்தைப் பார்க்க ஸ்க்ரோல் செய்யுங்கள்",
    Strings.DateRangePickerScrollToShowPreviousMonth to "முந்தைய மாதத்தைப் பார்க்க ஸ்க்ரோல் செய்யுங்கள்",
    Strings.DateRangePickerDayInRange to "வரம்பிற்குள் உள்ளது",
    Strings.DateRangeInputTitle to "தேதிகளை உள்ளிடுங்கள்",
    Strings.DateRangeInputInvalidRangeInput to "தவறான தேதி வரம்பை உள்ளிட்டுள்ளீர்கள்",
    Strings.BottomSheetPaneTitle to "கீழ்ப்புற ஷீட்",
    Strings.BottomSheetDragHandleDescription to "இழுப்பதற்கான ஹேண்டில்",
    Strings.BottomSheetPartialExpandDescription to "கீழ்ப்புற ஷீட்டைச் சுருக்கும்",
    Strings.BottomSheetDismissDescription to "கீழ்ப்புற ஷீட்டை நிராகரிக்கும்",
    Strings.BottomSheetExpandDescription to "கீழ்ப்புற ஷீட்டை விரிவாக்கும்",
    Strings.TooltipPaneDescription to "உதவிக்குறிப்பு",
    Strings.TooltipLongPressLabel to "உதவிக்குறிப்பைக் காட்டு",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM/PM என்பதைத் தேர்ந்தெடுக்கலாம்",
    Strings.TimePickerHourSelection to "மணிநேரத்தைத் தேர்ந்தெடுக்கலாம்",
    Strings.TimePickerMinuteSelection to "நிமிடங்களைத் தேர்ந்தெடுக்கலாம்",
    Strings.TimePickerHourSuffix to "%1\$d மணி",
    Strings.TimePicker24HourSuffix to "%1\$d மணி",
    Strings.TimePickerMinuteSuffix to "%1\$d நிமிடங்கள்",
    Strings.TimePickerMinute to "நிமிடம்",
    Strings.TimePickerHour to "மணிநேரம்",
    Strings.TimePickerMinuteTextField to "நிமிடங்களுக்கு",
    Strings.TimePickerHourTextField to "மணிநேரத்திற்கு",
)
