/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.mr() = mapOf(
    Strings.NavigationMenu to "नेव्हिगेशन मेनू",
    Strings.ExposedDropdownMenu to "ड्रॉपडाउन मेनू",
    Strings.CloseDrawer to "नेव्हिगेशन मेनू बंद करा",
    Strings.CloseSheet to "शीट बंद करा",
    Strings.DefaultErrorMessage to "इनपुट चुकीचे आहे",
    Strings.SliderRangeStart to "रेंजची सुरुवात",
    Strings.SliderRangeEnd to "रेंजचा शेवट",
    Strings.Dialog to "डायलॉग",
    Strings.MenuExpanded to "विस्तारित केला आहे",
    Strings.MenuCollapsed to "कोलॅप्स केला आहे",
    Strings.SnackbarDismiss to "डिसमिस करा",
    Strings.SearchBarSearch to "शोधा",
    Strings.SuggestionsAvailable to "सूचना खाली आहेत",
    Strings.DatePickerTitle to "तारीख निवडा",
    Strings.DatePickerHeadline to "निवडलेली तारीख",
    Strings.DatePickerSwitchToYearSelection to "वर्ष निवडणे यावर स्विच करा",
    Strings.DatePickerSwitchToDaySelection to "वर्ष निवडण्यासाठी स्‍वाइप करा किंवा दिवस निवडण्यावर परत स्विच करण्यासाठी टॅप करा",
    Strings.DatePickerSwitchToNextMonth to "पुढील महिन्यावर बदला",
    Strings.DatePickerSwitchToPreviousMonth to "मागील महिन्यावर बदला",
    Strings.DatePickerNavigateToYearDescription to "%1\$s वर्षावर नेव्हिगेट करा",
    Strings.DatePickerHeadlineDescription to "सध्याची निवड: %1\$s",
    Strings.DatePickerNoSelectionDescription to "काहीही नाही",
    Strings.DatePickerTodayDescription to "आज",
    Strings.DatePickerYearPickerPaneTitle to "वर्ष पिकर दृश्यमान आहे",
    Strings.DateInputTitle to "तारीख निवडा",
    Strings.DateInputHeadline to "एंटर केलेली तारीख",
    Strings.DateInputLabel to "तारीख",
    Strings.DateInputHeadlineDescription to "एंटर केली तारीख: %1\$s",
    Strings.DateInputNoInputDescription to "काहीही नाही",
    Strings.DateInputInvalidNotAllowed to "अशा तारखेला अनुमती नाही: %1\$s",
    Strings.DateInputInvalidForPattern to "तारीख ही अपेक्षित पॅटर्नशी जुळत नाही: %1\$s",
    Strings.DateInputInvalidYearRange to "तारीख ही %1\$s - %2\$s या अपेक्षित रेंजच्या बाहेरची आहे",
    Strings.DatePickerSwitchToCalendarMode to "कॅलेंडर इनपुट मोडवर स्विच करा",
    Strings.DatePickerSwitchToInputMode to "टेक्स्ट इनपुट मोडवर स्विच करा",
    Strings.DatePickerScrollToShowLaterYears to "नंतरची वर्षे दाखवण्यासाठी स्क्रोल करा",
    Strings.DatePickerScrollToShowEarlierYears to "मागील वर्षे दाखवण्यासाठी स्क्रोल करा",
    Strings.DateRangePickerTitle to "तारखा निवडा",
    Strings.DateRangePickerStartHeadline to "सुरू होण्याची तारीख",
    Strings.DateRangePickerEndHeadline to "संपण्याची तारीख",
    Strings.DateRangePickerScrollToShowNextMonth to "पुढील महिना दाखवण्यासाठी स्क्रोल करा",
    Strings.DateRangePickerScrollToShowPreviousMonth to "मागील महिना दाखवण्यासाठी स्क्रोल करा",
    Strings.DateRangePickerDayInRange to "रेंजमध्ये",
    Strings.DateRangeInputTitle to "तारखा एंटर करा",
    Strings.DateRangeInputInvalidRangeInput to "तारीख रेंजचे इनपुट चुकीचे आहे",
    Strings.BottomSheetPaneTitle to "तळाशी असलेली शीट",
    Strings.BottomSheetDragHandleDescription to "ड्रॅग हॅंडल",
    Strings.BottomSheetPartialExpandDescription to "तळाशी असलेली शीट कोलॅप्स करा",
    Strings.BottomSheetDismissDescription to "तळाशी असलेली शीट डिसमिस करा",
    Strings.BottomSheetExpandDescription to "तळाशी असलेली शीट विस्तारीत करा",
    Strings.TooltipPaneDescription to "टूलटिप",
    Strings.TooltipLongPressLabel to "टूलटिप दाखवा",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM किंवा PM निवडा",
    Strings.TimePickerHourSelection to "तास निवडा",
    Strings.TimePickerMinuteSelection to "मिनिटे निवडा",
    Strings.TimePickerHourSuffix to "%1\$d वाजता",
    Strings.TimePicker24HourSuffix to "%1\$d तास",
    Strings.TimePickerMinuteSuffix to "%1\$d मिनिटे",
    Strings.TimePickerMinute to "मिनिट",
    Strings.TimePickerHour to "तास",
    Strings.TimePickerMinuteTextField to "मिनिटांसाठी",
    Strings.TimePickerHourTextField to "तासासाठी",
)
