/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.mn() = mapOf(
    Strings.NavigationMenu to "Навигацын цэс",
    Strings.ExposedDropdownMenu to "Унадаг цэс",
    Strings.CloseDrawer to "Навигацын цэсийг хаах",
    Strings.CloseSheet to "Хүснэгтийг хаах",
    Strings.DefaultErrorMessage to "Буруу оролт",
    Strings.SliderRangeStart to "Мужийн эхлэл",
    Strings.SliderRangeEnd to "Мужийн төгсгөл",
    Strings.Dialog to "Харилцах цонх",
    Strings.MenuExpanded to "Дэлгэсэн",
    Strings.MenuCollapsed to "Хураасан",
    Strings.SnackbarDismiss to "Хаах",
    Strings.SearchBarSearch to "Хайх",
    Strings.SuggestionsAvailable to "Доорх зөвлөмжүүд",
    Strings.DatePickerTitle to "Огноо сонгох",
    Strings.DatePickerHeadline to "Сонгосон огноо",
    Strings.DatePickerSwitchToYearSelection to "Он сонгох руу сэлгэх",
    Strings.DatePickerSwitchToDaySelection to "Он сонгохын тулд шудрах эсвэл өдөр сонгох руу буцааж сэлгэхийн тулд товшино уу",
    Strings.DatePickerSwitchToNextMonth to "Дараагийн сар луу өөрчлөх",
    Strings.DatePickerSwitchToPreviousMonth to "Өмнөх сар луу өөрчлөх",
    Strings.DatePickerNavigateToYearDescription to "%1\$s он руу шилжих",
    Strings.DatePickerHeadlineDescription to "Одоогийн сонголт: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Байхгүй",
    Strings.DatePickerTodayDescription to "Өнөөдөр",
    Strings.DatePickerYearPickerPaneTitle to "Он сонгогч харагдаж байна",
    Strings.DateInputTitle to "Огноо сонгох",
    Strings.DateInputHeadline to "Оруулсан огноо",
    Strings.DateInputLabel to "Огноо",
    Strings.DateInputHeadlineDescription to "Оруулсан огноо: %1\$s",
    Strings.DateInputNoInputDescription to "Байхгүй",
    Strings.DateInputInvalidNotAllowed to "Зөвшөөрөөгүй огноо: %1\$s",
    Strings.DateInputInvalidForPattern to "Огноо нь тооцоолсон хээтэй таарахгүй байна: %1\$s",
    Strings.DateInputInvalidYearRange to "Тооцоолсон оны %1\$s - %2\$s мужаас гарсан огноо",
    Strings.DatePickerSwitchToCalendarMode to "Календарийн орох горим руу сэлгэх",
    Strings.DatePickerSwitchToInputMode to "Текст оруулах горим руу сэлгэх",
    Strings.DatePickerScrollToShowLaterYears to "Дараагийн жилүүдийг харуулахын тулд гүйлгэнэ үү",
    Strings.DatePickerScrollToShowEarlierYears to "Өмнөх жилүүдийг харуулахын тулд гүйлгэнэ үү",
    Strings.DateRangePickerTitle to "Огноо сонгох",
    Strings.DateRangePickerStartHeadline to "Эхлэх огноо",
    Strings.DateRangePickerEndHeadline to "Дуусах огноо",
    Strings.DateRangePickerScrollToShowNextMonth to "Дараагийн сарыг харуулахын тулд гүйлгэнэ үү",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Өмнөх сарыг харуулахын тулд гүйлгэнэ үү",
    Strings.DateRangePickerDayInRange to "Мужид байгаа",
    Strings.DateRangeInputTitle to "Огноо оруулах",
    Strings.DateRangeInputInvalidRangeInput to "Хугацааны интервалын оролт буруу байна",
    Strings.BottomSheetPaneTitle to "Доод хүснэгт",
    Strings.BottomSheetDragHandleDescription to "Чирэх бариул",
    Strings.BottomSheetPartialExpandDescription to "Доод хүснэгтийг хураах",
    Strings.BottomSheetDismissDescription to "Доод хүснэгтийг хаах",
    Strings.BottomSheetExpandDescription to "Доод хүснэгтийг дэлгэх",
    Strings.TooltipPaneDescription to "Зөвлөмж",
    Strings.TooltipLongPressLabel to "Зөвлөмж харуулах",
    Strings.TimePickerPM to "ҮХ",
    Strings.TimePickerAM to "ҮӨ",
    Strings.TimePickerPeriodToggle to "ҮӨ эсвэл ҮХ эсэхийг сонгоно уу",
    Strings.TimePickerHourSelection to "Цаг сонгох",
    Strings.TimePickerMinuteSelection to "Минут сонгох",
    Strings.TimePickerHourSuffix to "%1\$d цаг",
    Strings.TimePicker24HourSuffix to "%1\$d цаг",
    Strings.TimePickerMinuteSuffix to "%1\$d минут",
    Strings.TimePickerMinute to "Минут",
    Strings.TimePickerHour to "Цаг",
    Strings.TimePickerMinuteTextField to "минутын турш",
    Strings.TimePickerHourTextField to "цагийн турш",
)
