/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.lo() = mapOf(
    Strings.NavigationMenu to "ເມນູການນຳທາງ",
    Strings.ExposedDropdownMenu to "ເມນູແບບເລື່ອນລົງ",
    Strings.CloseDrawer to "ປິດ​ເມ​ນູການ​ນຳ​ທາງ",
    Strings.CloseSheet to "ປິດຊີດ",
    Strings.DefaultErrorMessage to "ຂໍ້ມູນທີ່ປ້ອນເຂົ້າບໍ່ຖືກຕ້ອງ",
    Strings.SliderRangeStart to "ເລີ່ມຕົ້ນໄລຍະ",
    Strings.SliderRangeEnd to "ສິ້ນສຸດໄລຍະ",
    Strings.Dialog to "ກ່ອງໂຕ້ຕອບ",
    Strings.MenuExpanded to "ຂະຫຍາຍແລ້ວ",
    Strings.MenuCollapsed to "ຫຍໍ້ລົງແລ້ວ",
    Strings.SnackbarDismiss to "ປິດໄວ້",
    Strings.SearchBarSearch to "ຊອກຫາ",
    Strings.SuggestionsAvailable to "ມີຄຳແນະນຳຢູ່ຂ້າງລຸ່ມ",
    Strings.DatePickerTitle to "ເລືອກວັນທີ",
    Strings.DatePickerHeadline to "ວັນທີທີ່ເລືອກໄວ້",
    Strings.DatePickerSwitchToYearSelection to "ປ່ຽນໄປເລືອກປີ",
    Strings.DatePickerSwitchToDaySelection to "ປັດເພື່ອເລືອກປີ ຫຼື ແຕະເພື່ອປ່ຽນກັບໄປຫາການເລືອກວັນ",
    Strings.DatePickerSwitchToNextMonth to "ປ່ຽນເປັນເດືອນຕໍ່ໄປ",
    Strings.DatePickerSwitchToPreviousMonth to "ປ່ຽນເປັນເດືອນກ່ອນໜ້າ",
    Strings.DatePickerNavigateToYearDescription to "ນຳທາງໄປຫາປີ %1\$s",
    Strings.DatePickerHeadlineDescription to "ການເລືອກປັດຈຸບັນ: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ບໍ່ມີ",
    Strings.DatePickerTodayDescription to "ມື້ນີ້",
    Strings.DatePickerYearPickerPaneTitle to "ສະແດງຕົວເລືອກປີ",
    Strings.DateInputTitle to "ເລືອກວັນທີ",
    Strings.DateInputHeadline to "ລະບຸວັນທີແລ້ວ",
    Strings.DateInputLabel to "ວັນທີ",
    Strings.DateInputHeadlineDescription to "ລະບຸວັນທີແລ້ວ: %1\$s",
    Strings.DateInputNoInputDescription to "ບໍ່ມີ",
    Strings.DateInputInvalidNotAllowed to "ບໍ່ອະນຸຍາດໃຫ້ໃຊ້ວັນທີ: %1\$s",
    Strings.DateInputInvalidForPattern to "ວັນທີບໍ່ກົງກັບຮູບແບບທີ່ຄາດໄວ້: %1\$s",
    Strings.DateInputInvalidYearRange to "ວັນທີຢູ່ນອກໄລຍະປີທີ່ຄາດໄວ້ %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "ສະຫຼັບໄປໃຊ້ໂໝດປ້ອນຂໍ້ມູນປະຕິທິນ",
    Strings.DatePickerSwitchToInputMode to "ສະຫຼັບໄປໃຊ້ໂໝດປ້ອນຂໍ້ຄວາມ",
    Strings.DatePickerScrollToShowLaterYears to "ເລື່ອນເພື່ອສະແດງປີຫຼັງຈາກນີ້",
    Strings.DatePickerScrollToShowEarlierYears to "ເລື່ອນເພື່ອສະແດງປີກ່ອນໜ້ານີ້",
    Strings.DateRangePickerTitle to "ເລືອກວັນທີ",
    Strings.DateRangePickerStartHeadline to "ວັນທີເລີ່ມຕົ້ນ",
    Strings.DateRangePickerEndHeadline to "ວັນທີສິ້ນສຸດ",
    Strings.DateRangePickerScrollToShowNextMonth to "ເລື່ອນເພື່ອສະແດງເດືອນຕໍ່ໄປ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ເລື່ອນເພື່ອສະແດງເດືອນກ່ອນໜ້າ",
    Strings.DateRangePickerDayInRange to "ຢູ່ໃນໄລຍະວັນທີທີ່ເລືອກ",
    Strings.DateRangeInputTitle to "ໃສ່ວັນທີ",
    Strings.DateRangeInputInvalidRangeInput to "ອິນພຸດໄລຍະວັນທີບໍ່ຖືກຕ້ອງ",
    Strings.BottomSheetPaneTitle to "ຊີດລຸ່ມສຸດ",
    Strings.BottomSheetDragHandleDescription to "ບ່ອນຈັບລາກ",
    Strings.BottomSheetPartialExpandDescription to "ຫຍໍ້ຊີດລຸ່ມສຸດລົງ",
    Strings.BottomSheetDismissDescription to "ປິດຊີດລຸ່ມສຸດໄວ້",
    Strings.BottomSheetExpandDescription to "ຂະຫຍາຍຊີດລຸ່ມສຸດ",
    Strings.TooltipPaneDescription to "ຄຳແນະນຳ",
    Strings.TooltipLongPressLabel to "ສະແດງຄຳແນະນຳ",
    Strings.TimePickerPM to "ຫຼັງທ່ຽງ",
    Strings.TimePickerAM to "ກ່ອນທ່ຽງ",
    Strings.TimePickerPeriodToggle to "ເລືອກກ່ອນທ່ຽງ ຫຼື ຫຼັງທ່ຽງ",
    Strings.TimePickerHourSelection to "ເລືອກຊົ່ວໂມງ",
    Strings.TimePickerMinuteSelection to "ເລືອກນາທີ",
    Strings.TimePickerHourSuffix to "%1\$d ໂມງ",
    Strings.TimePicker24HourSuffix to "%1\$d ຊົ່ວໂມງ",
    Strings.TimePickerMinuteSuffix to "%1\$d ນາທີ",
    Strings.TimePickerMinute to "ນາທີ",
    Strings.TimePickerHour to "ຊົ່ວໂມງ",
    Strings.TimePickerMinuteTextField to "ສຳລັບນາທີ",
    Strings.TimePickerHourTextField to "ສຳລັບຊົ່ວໂມງ",
)
