/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ky() = mapOf(
    Strings.NavigationMenu to "Чабыттоо менюсу",
    Strings.ExposedDropdownMenu to "Түрүлмө меню",
    Strings.CloseDrawer to "Чабыттоо менюсун жабуу",
    Strings.CloseSheet to "Баракты жабуу",
    Strings.DefaultErrorMessage to "Киргизилген маалымат жараксыз",
    Strings.SliderRangeStart to "Диапазондун башы",
    Strings.SliderRangeEnd to "Диапазондун аягы",
    Strings.Dialog to "Диалог",
    Strings.MenuExpanded to "Жайылып көрсөтүлдү",
    Strings.MenuCollapsed to "Жыйыштырылды",
    Strings.SnackbarDismiss to "Жабуу",
    Strings.SearchBarSearch to "Издөө",
    Strings.SuggestionsAvailable to "Сунуштар төмөндө келтирилди",
    Strings.DatePickerTitle to "Күндү тандоо",
    Strings.DatePickerHeadline to "Тандалган күн",
    Strings.DatePickerSwitchToYearSelection to "Жыл тандоого которулуу",
    Strings.DatePickerSwitchToDaySelection to "Жылды тандоо үчүн экранды сүрүңүз же күндү тандоого кайтуу үчүн таптап коюңуз",
    Strings.DatePickerSwitchToNextMonth to "Кийинки айга өзгөртүү",
    Strings.DatePickerSwitchToPreviousMonth to "Мурунку айга өзгөртүү",
    Strings.DatePickerNavigateToYearDescription to "%1\$s-жылга өтүү",
    Strings.DatePickerHeadlineDescription to "Учурда %1\$s тандалды",
    Strings.DatePickerNoSelectionDescription to "Жок",
    Strings.DatePickerTodayDescription to "Бүгүн",
    Strings.DatePickerYearPickerPaneTitle to "Көрсөтүлгөн жыл тандагыч",
    Strings.DateInputTitle to "Күндү тандоо",
    Strings.DateInputHeadline to "Киргизилген күн",
    Strings.DateInputLabel to "Күнү",
    Strings.DateInputHeadlineDescription to "Киргизилген күн: %1\$s",
    Strings.DateInputNoInputDescription to "Жок",
    Strings.DateInputInvalidNotAllowed to "Күндүн мындай форматын колдонууга болбойт: %1\$s",
    Strings.DateInputInvalidForPattern to "Күндүн форматы үлгүгө дал келген жок: %1\$s",
    Strings.DateInputInvalidYearRange to "Күн %1\$s — %2\$s деп белгиленген жылдар диапазонуна кирбей калды",
    Strings.DatePickerSwitchToCalendarMode to "Жылнаамага киргизүү режимине которулуу",
    Strings.DatePickerSwitchToInputMode to "Текст киргизүү режимине которулуу",
    Strings.DatePickerScrollToShowLaterYears to "Кийинки жылдарды көрүү үчүн сыдырыңыз",
    Strings.DatePickerScrollToShowEarlierYears to "Мурунку жылдарды көрүү үчүн сыдырыңыз",
    Strings.DateRangePickerTitle to "Күндөрдү тандоо",
    Strings.DateRangePickerStartHeadline to "Башталуу күнү",
    Strings.DateRangePickerEndHeadline to "Аяктоо күнү",
    Strings.DateRangePickerScrollToShowNextMonth to "Кийинки айды көрүү үчүн сыдырыңыз",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Мурунку айды көрүү үчүн сыдырыңыз",
    Strings.DateRangePickerDayInRange to "Төмөнкү убакыт аралыгындагы күн",
    Strings.DateRangeInputTitle to "Күндөрдү киргизүү",
    Strings.DateRangeInputInvalidRangeInput to "Даталар диапазону туура эмес тандалды",
    Strings.BottomSheetPaneTitle to "Ылдыйкы экран",
    Strings.BottomSheetDragHandleDescription to "Сүйрөө маркери",
    Strings.BottomSheetPartialExpandDescription to "Ылдыйкы экранды жыйыштыруу",
    Strings.BottomSheetDismissDescription to "Ылдыйкы экранды жабуу",
    Strings.BottomSheetExpandDescription to "Ылдыйкы экранды жайып көрсөтүү",
    Strings.TooltipPaneDescription to "Калкып чыгуучу кеңеш",
    Strings.TooltipLongPressLabel to "Калкып чыгуучу кеңешти көрсөтүү",
    Strings.TimePickerPM to "түштөн кийин",
    Strings.TimePickerAM to "түшкө чейин",
    Strings.TimePickerPeriodToggle to "Түшкө чейинки же түштөн кийинки убакытты тандоо",
    Strings.TimePickerHourSelection to "Саат тандоо",
    Strings.TimePickerMinuteSelection to "Мүнөттөрдү тандаңыз",
    Strings.TimePickerHourSuffix to "%1\$d саат",
    Strings.TimePicker24HourSuffix to "%1\$d саат",
    Strings.TimePickerMinuteSuffix to "%1\$d мүнөт",
    Strings.TimePickerMinute to "Мүнөт",
    Strings.TimePickerHour to "Саат",
    Strings.TimePickerMinuteTextField to "мүнөткө",
    Strings.TimePickerHourTextField to "саатка",
)
