/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.kk() = mapOf(
    Strings.NavigationMenu to "Навигация мәзірі",
    Strings.ExposedDropdownMenu to "Ашылмалы мәзір",
    Strings.CloseDrawer to "Навигация мәзірін жабу",
    Strings.CloseSheet to "Парақты жабу",
    Strings.DefaultErrorMessage to "Енгізілген мән жарамсыз.",
    Strings.SliderRangeStart to "Аралықтың басы",
    Strings.SliderRangeEnd to "Аралықтың соңы",
    Strings.Dialog to "Диалогтік терезе",
    Strings.MenuExpanded to "Жайылды",
    Strings.MenuCollapsed to "Жиылды",
    Strings.SnackbarDismiss to "Жабу",
    Strings.SearchBarSearch to "Іздеу",
    Strings.SuggestionsAvailable to "Төмендегі ұсыныстар",
    Strings.DatePickerTitle to "Күн таңдау",
    Strings.DatePickerHeadline to "Таңдалған күн",
    Strings.DatePickerSwitchToYearSelection to "Жыл таңдауға өту",
    Strings.DatePickerSwitchToDaySelection to "Жыл таңдау үшін сырғытыңыз. Күн таңдауға ауысу үшін түртіңіз.",
    Strings.DatePickerSwitchToNextMonth to "Келесі айға өзгерту",
    Strings.DatePickerSwitchToPreviousMonth to "Алдыңғы айға өзгерту",
    Strings.DatePickerNavigateToYearDescription to "Мына жылға өту: %1\$s",
    Strings.DatePickerHeadlineDescription to "Қазіргі таңдау: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ешқандай",
    Strings.DatePickerTodayDescription to "Бүгін",
    Strings.DatePickerYearPickerPaneTitle to "Көрсетілген жыл таңдағышы",
    Strings.DateInputTitle to "Күн таңдау",
    Strings.DateInputHeadline to "Деректер енгізілді",
    Strings.DateInputLabel to "Күні",
    Strings.DateInputHeadlineDescription to "Деректер енгізілді: %1\$s",
    Strings.DateInputNoInputDescription to "Ешқандай",
    Strings.DateInputInvalidNotAllowed to "Деректер рұқсат етілмейді: %1\$s",
    Strings.DateInputInvalidForPattern to "Деректер болжалды өрнекке сай келмейді: %1\$s",
    Strings.DateInputInvalidYearRange to "Күтілетін жыл аралығы: %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Күнтізбенің енгізу режиміне ауысу",
    Strings.DatePickerSwitchToInputMode to "Мәтін енгізу режиміне ауысу",
    Strings.DatePickerScrollToShowLaterYears to "Кейінгі жылдарды көрсету үшін айналдырыңыз.",
    Strings.DatePickerScrollToShowEarlierYears to "Алдыңғы жылдарды көрсету үшін айналдырыңыз.",
    Strings.DateRangePickerTitle to "Күндер таңдау",
    Strings.DateRangePickerStartHeadline to "Басталу күні",
    Strings.DateRangePickerEndHeadline to "Аяқталу күні",
    Strings.DateRangePickerScrollToShowNextMonth to "Келесі айды көрсету үшін айналдырыңыз.",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Алдыңғы айды көрсету үшін айналдырыңыз.",
    Strings.DateRangePickerDayInRange to "Күндер аралығында",
    Strings.DateRangeInputTitle to "Күндерді енгізіңіз",
    Strings.DateRangeInputInvalidRangeInput to "Жарамсыз күндер аралығы енгізілген.",
    Strings.BottomSheetPaneTitle to "Төменгі парақша",
    Strings.BottomSheetDragHandleDescription to "Сүйрейтін тетік",
    Strings.BottomSheetPartialExpandDescription to "Төменгі парақшаны жию",
    Strings.BottomSheetDismissDescription to "Төменгі парақшаны жабу",
    Strings.BottomSheetExpandDescription to "Төменгі парақшаны жаю",
    Strings.TooltipPaneDescription to "Қалқыма көмек",
    Strings.TooltipLongPressLabel to "Қалқыма көмекті көрсету",
    Strings.TimePickerPM to "түстен кейін",
    Strings.TimePickerAM to "түске дейін",
    Strings.TimePickerPeriodToggle to "\"AM\" немесе \"PM\" форматын таңдау",
    Strings.TimePickerHourSelection to "Сағатты таңдау",
    Strings.TimePickerMinuteSelection to "Минут таңдау",
    Strings.TimePickerHourSuffix to "%1\$d сағат",
    Strings.TimePicker24HourSuffix to "%1\$d сағат",
    Strings.TimePickerMinuteSuffix to "%1\$d минут",
    Strings.TimePickerMinute to "Mинут",
    Strings.TimePickerHour to "Сағат",
    Strings.TimePickerMinuteTextField to "минут",
    Strings.TimePickerHourTextField to "сағат",
)
