/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.iw() = mapOf(
    Strings.NavigationMenu to "תפריט הניווט",
    Strings.ExposedDropdownMenu to "תפריט נפתח",
    Strings.CloseDrawer to "סגירת תפריט הניווט",
    Strings.CloseSheet to "סגירת הגיליון",
    Strings.DefaultErrorMessage to "הקלט לא תקין",
    Strings.SliderRangeStart to "תחילת הטווח",
    Strings.SliderRangeEnd to "סוף הטווח",
    Strings.Dialog to "תיבת דו-שיח",
    Strings.MenuExpanded to "התפריט הנפתח מורחב",
    Strings.MenuCollapsed to "התפריט הנפתח מכווץ",
    Strings.SnackbarDismiss to "סגירה",
    Strings.SearchBarSearch to "חיפוש",
    Strings.SuggestionsAvailable to "הצעות מופיעות למטה",
    Strings.DatePickerTitle to "בחירת תאריך",
    Strings.DatePickerHeadline to "התאריך הנבחר",
    Strings.DatePickerSwitchToYearSelection to "החלפה לבחירה של שנה",
    Strings.DatePickerSwitchToDaySelection to "יש להחליק כדי לבחור שנה, או להקיש כדי לחזור לבחירת היום",
    Strings.DatePickerSwitchToNextMonth to "מעבר לחודש הבא",
    Strings.DatePickerSwitchToPreviousMonth to "מעבר לחודש הקודם",
    Strings.DatePickerNavigateToYearDescription to "‏ניווט לשנת %1\$s",
    Strings.DatePickerHeadlineDescription to "‏הבחירה הנוכחית: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ללא",
    Strings.DatePickerTodayDescription to "היום",
    Strings.DatePickerYearPickerPaneTitle to "בורר השנה גלוי",
    Strings.DateInputTitle to "בחירת תאריך",
    Strings.DateInputHeadline to "התאריך שהוזן",
    Strings.DateInputLabel to "תאריך",
    Strings.DateInputHeadlineDescription to "‏התאריך שהוזן: %1\$s",
    Strings.DateInputNoInputDescription to "ללא",
    Strings.DateInputInvalidNotAllowed to "‏תאריך לא מורשה: %1\$s",
    Strings.DateInputInvalidForPattern to "‏התאריך לא תואם למבנה הצפוי: %1\$s",
    Strings.DateInputInvalidYearRange to "‏התאריך נמצא מחוץ לטווח השנים הצפוי %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "מעבר לשיטת קלט של יומן",
    Strings.DatePickerSwitchToInputMode to "מעבר לשיטת קלט של טקסט",
    Strings.DatePickerScrollToShowLaterYears to "צריך לגלול כדי להציג את השנים המאוחרות",
    Strings.DatePickerScrollToShowEarlierYears to "צריך לגלול כדי להציג את השנים הקודמות",
    Strings.DateRangePickerTitle to "בחירת תאריכים",
    Strings.DateRangePickerStartHeadline to "תאריך התחלה",
    Strings.DateRangePickerEndHeadline to "תאריך סיום",
    Strings.DateRangePickerScrollToShowNextMonth to "צריך לגלול כדי להציג את החודש הבא",
    Strings.DateRangePickerScrollToShowPreviousMonth to "צריך לגלול כדי להציג את החודש הקודם",
    Strings.DateRangePickerDayInRange to "בטווח",
    Strings.DateRangeInputTitle to "הזנת תאריכים",
    Strings.DateRangeInputInvalidRangeInput to "קלט טווח תאריכים לא חוקי",
    Strings.BottomSheetPaneTitle to "גיליון תחתון",
    Strings.BottomSheetDragHandleDescription to "נקודת אחיזה לגרירה",
    Strings.BottomSheetPartialExpandDescription to "כיווץ הגיליון התחתון",
    Strings.BottomSheetDismissDescription to "סגירת הגיליון התחתון",
    Strings.BottomSheetExpandDescription to "הרחבת הגיליון התחתון",
    Strings.TooltipPaneDescription to "הסבר קצר",
    Strings.TooltipLongPressLabel to "הצגת הסבר קצר",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "‏צריך לבחור ב-AM או ב-PM",
    Strings.TimePickerHourSelection to "בחירת שעה",
    Strings.TimePickerMinuteSelection to "בחירת דקות",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "‏%1\$d שעות",
    Strings.TimePickerMinuteSuffix to "‏%1\$d דקות",
    Strings.TimePickerMinute to "דקות",
    Strings.TimePickerHour to "שעות",
    Strings.TimePickerMinuteTextField to "דקות",
    Strings.TimePickerHourTextField to "שעות",
)
