/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.hu() = mapOf(
    Strings.NavigationMenu to "Navigációs menü",
    Strings.ExposedDropdownMenu to "Legördülő menü",
    Strings.CloseDrawer to "Navigációs menü bezárása",
    Strings.CloseSheet to "Munkalap bezárása",
    Strings.DefaultErrorMessage to "Érvénytelen adat",
    Strings.SliderRangeStart to "Tartomány kezdete",
    Strings.SliderRangeEnd to "Tartomány vége",
    Strings.Dialog to "Párbeszédpanel",
    Strings.MenuExpanded to "Kibontva",
    Strings.MenuCollapsed to "Összecsukva",
    Strings.SnackbarDismiss to "Elvetés",
    Strings.SearchBarSearch to "Keresés",
    Strings.SuggestionsAvailable to "Javaslatok alább",
    Strings.DatePickerTitle to "Dátum kiválasztása",
    Strings.DatePickerHeadline to "Kiválasztott dátum",
    Strings.DatePickerSwitchToYearSelection to "Váltás az év kiválasztására",
    Strings.DatePickerSwitchToDaySelection to "Csúsztatással kiválaszthatja a kívánt évet, vagy koppintással visszaválthat a nap kiválasztásához.",
    Strings.DatePickerSwitchToNextMonth to "Váltás a következő hónapra",
    Strings.DatePickerSwitchToPreviousMonth to "Váltás az előző hónapra",
    Strings.DatePickerNavigateToYearDescription to "Navigálás a következő évhez: %1\$s",
    Strings.DatePickerHeadlineDescription to "Jelenleg kiválasztva: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nincs",
    Strings.DatePickerTodayDescription to "Ma",
    Strings.DatePickerYearPickerPaneTitle to "Látható az évválasztó",
    Strings.DateInputTitle to "Dátum kiválasztása",
    Strings.DateInputHeadline to "Megadott dátum",
    Strings.DateInputLabel to "Dátum",
    Strings.DateInputHeadlineDescription to "Megadott dátum: %1\$s",
    Strings.DateInputNoInputDescription to "Nincs",
    Strings.DateInputInvalidNotAllowed to "Nem engedélyezett dátum: %1\$s",
    Strings.DateInputInvalidForPattern to "A dátum nem felel meg a várt formátumnak: %1\$s",
    Strings.DateInputInvalidYearRange to "A dátum a várt időtartományon (%1\$s – %2\$s) kívül esik",
    Strings.DatePickerSwitchToCalendarMode to "Váltás naptárbeviteli módra",
    Strings.DatePickerSwitchToInputMode to "Váltás szövegbeviteli módra",
    Strings.DatePickerScrollToShowLaterYears to "Görgessen a későbbi évek megjelenítéséhez",
    Strings.DatePickerScrollToShowEarlierYears to "Görgessen a korábbi évek megjelenítéséhez",
    Strings.DateRangePickerTitle to "Dátumok kiválasztása",
    Strings.DateRangePickerStartHeadline to "Kezdő dátum",
    Strings.DateRangePickerEndHeadline to "Záró dátum",
    Strings.DateRangePickerScrollToShowNextMonth to "Görgessen a következő hónap megjelenítéséhez",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Görgessen az előző hónap megjelenítéséhez",
    Strings.DateRangePickerDayInRange to "Tartományon belül",
    Strings.DateRangeInputTitle to "Dátumok megadása",
    Strings.DateRangeInputInvalidRangeInput to "Érvénytelen a megadott dátumtartomány",
    Strings.BottomSheetPaneTitle to "Alsó lap",
    Strings.BottomSheetDragHandleDescription to "Fogópont",
    Strings.BottomSheetPartialExpandDescription to "Az alsó lap összecsukása",
    Strings.BottomSheetDismissDescription to "Az alsó lap elvetése",
    Strings.BottomSheetExpandDescription to "Az alsó lap kibontása",
    Strings.TooltipPaneDescription to "Elemleírás",
    Strings.TooltipLongPressLabel to "Elemleírás megjelenítése",
    Strings.TimePickerPM to "du.",
    Strings.TimePickerAM to "de.",
    Strings.TimePickerPeriodToggle to "Napszak kiválasztása",
    Strings.TimePickerHourSelection to "Óra kiválasztása",
    Strings.TimePickerMinuteSelection to "Perc kiválasztása",
    Strings.TimePickerHourSuffix to "%1\$d óra",
    Strings.TimePicker24HourSuffix to "%1\$d óra",
    Strings.TimePickerMinuteSuffix to "%1\$d perc",
    Strings.TimePickerMinute to "Perc",
    Strings.TimePickerHour to "Óra",
    Strings.TimePickerMinuteTextField to "perc megadása",
    Strings.TimePickerHourTextField to "óra megadása",
)
