/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.gl() = mapOf(
    Strings.NavigationMenu to "Menú de navegación",
    Strings.ExposedDropdownMenu to "Menú despregable",
    Strings.CloseDrawer to "Pechar menú de navegación",
    Strings.CloseSheet to "Pechar folla",
    Strings.DefaultErrorMessage to "O texto escrito non é válido",
    Strings.SliderRangeStart to "Inicio do intervalo",
    Strings.SliderRangeEnd to "Fin do intervalo",
    Strings.Dialog to "Cadro de diálogo",
    Strings.MenuExpanded to "Despregado",
    Strings.MenuCollapsed to "Contraído",
    Strings.SnackbarDismiss to "Pechar",
    Strings.SearchBarSearch to "Buscar",
    Strings.SuggestionsAvailable to "Hai suxestións abaixo",
    Strings.DatePickerTitle to "Selecciona a data",
    Strings.DatePickerHeadline to "Data seleccionada",
    Strings.DatePickerSwitchToYearSelection to "Cambiar á selección do ano",
    Strings.DatePickerSwitchToDaySelection to "Pasar o dedo para seleccionar un ano ou tocar a pantalla para volver á selección do día",
    Strings.DatePickerSwitchToNextMonth to "Cambiar ao mes seguinte",
    Strings.DatePickerSwitchToPreviousMonth to "Cambiar ao mes anterior",
    Strings.DatePickerNavigateToYearDescription to "Ir ao ano %1\$s",
    Strings.DatePickerHeadlineDescription to "Selección actual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ningunha",
    Strings.DatePickerTodayDescription to "Hoxe",
    Strings.DatePickerYearPickerPaneTitle to "Selector de ano visible",
    Strings.DateInputTitle to "Selecciona a data",
    Strings.DateInputHeadline to "Data indicada",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data indicada: %1\$s",
    Strings.DateInputNoInputDescription to "Ningunha",
    Strings.DateInputInvalidNotAllowed to "Data non permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "A data non coincide co padrón esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "A data está fóra do intervalo de anos esperado (%1\$s - %2\$s)",
    Strings.DatePickerSwitchToCalendarMode to "Cambiar ao modo de introdución de texto do calendario",
    Strings.DatePickerSwitchToInputMode to "Cambiar ao modo de introdución de texto",
    Strings.DatePickerScrollToShowLaterYears to "Desprazarse para mostrar anos posteriores",
    Strings.DatePickerScrollToShowEarlierYears to "Desprazarse para mostrar anos anteriores",
    Strings.DateRangePickerTitle to "Selecciona as datas",
    Strings.DateRangePickerStartHeadline to "Data de inicio",
    Strings.DateRangePickerEndHeadline to "Data de finalización",
    Strings.DateRangePickerScrollToShowNextMonth to "Desprazarse para mostrar o mes seguinte",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Desprazarse para mostrar o mes anterior",
    Strings.DateRangePickerDayInRange to "Dentro do intervalo",
    Strings.DateRangeInputTitle to "Indica as datas",
    Strings.DateRangeInputInvalidRangeInput to "Indicouse un intervalo de datas que non é válido",
    Strings.BottomSheetPaneTitle to "Panel inferior",
    Strings.BottomSheetDragHandleDescription to "Controlador de arrastre",
    Strings.BottomSheetPartialExpandDescription to "Contrae o panel inferior",
    Strings.BottomSheetDismissDescription to "Pecha o panel inferior",
    Strings.BottomSheetExpandDescription to "Desprega o panel inferior",
    Strings.TooltipPaneDescription to "Cadro de información",
    Strings.TooltipLongPressLabel to "Mostrar o cadro de información",
    Strings.TimePickerPM to "p.m.",
    Strings.TimePickerAM to "a.m.",
    Strings.TimePickerPeriodToggle to "Selecciona a.m. ou p.m.",
    Strings.TimePickerHourSelection to "Selecciona a hora",
    Strings.TimePickerMinuteSelection to "Selecciona os minutos",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "por minuto",
    Strings.TimePickerHourTextField to "por hora",
)
