/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.material3.LegacyCalendarModelImpl;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0012\u0010\u0015\u001a\u00020\u00162\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ&\u0010\u001a\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001c\u0018\u00010\u001b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Landroidx/compose/material3/PlatformDateFormat;", "", "()V", "delegate", "Landroidx/compose/material3/LegacyCalendarModelImpl;", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "formatWithPattern", "", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "formatWithSkeleton", "skeleton", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "is24HourFormat", "", "parse", "Landroidx/compose/material3/CalendarDate;", "date", "weekdayNames", "", "Lkotlin/Pair;", "material3"})
public final class PlatformDateFormat {
    @NotNull
    public static final PlatformDateFormat INSTANCE = new PlatformDateFormat();
    @NotNull
    private static final LegacyCalendarModelImpl delegate = new LegacyCalendarModelImpl();

    private PlatformDateFormat() {
    }

    public final int getFirstDayOfWeek() {
        return delegate.getFirstDayOfWeek();
    }

    @NotNull
    public final String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return delegate.formatWithPattern(utcTimeMillis, pattern, locale);
    }

    @NotNull
    public final String formatWithSkeleton(long utcTimeMillis, @NotNull String skeleton, @NotNull Locale locale) {
        String string;
        Intrinsics.checkNotNullParameter((Object)skeleton, (String)"skeleton");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        switch (skeleton) {
            case "yMMMM": {
                string = "MMMM yyyy";
                break;
            }
            case "yMMMd": {
                string = "MMM d, yyyy";
                break;
            }
            case "yMMMMEEEEd": {
                string = "EEEE, MMMM d, yyyy";
                break;
            }
            default: {
                string = skeleton;
            }
        }
        String pattern = string;
        return this.formatWithPattern(utcTimeMillis, pattern, locale);
    }

    @Nullable
    public final CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return delegate.parse(date, pattern);
    }

    @NotNull
    public final DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return delegate.getDateInputFormat(locale);
    }

    @Nullable
    public final List<Pair<String, String>> weekdayNames(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return delegate.weekdayNames(locale);
    }

    public final boolean is24HourFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DateFormat dateFormat = DateFormat.getTimeInstance(1, locale);
        if (!(dateFormat instanceof SimpleDateFormat)) {
            return false;
        }
        String string = ((SimpleDateFormat)dateFormat).toPattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.toPattern()");
        return StringsKt.contains$default((CharSequence)string, (char)'H', (boolean)false, (int)2, null);
    }
}

