/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.ActualJvmKt;
import androidx.compose.material3.CalendarDate;
import androidx.compose.material3.CalendarModel;
import androidx.compose.material3.CalendarMonth;
import androidx.compose.material3.DateInputFormat;
import androidx.compose.material3.KotlinxDatetimeCalendarModelKt;
import androidx.compose.material3.PlatformDateFormat;
import java.time.DayOfWeek;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0004H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010*\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0004H\u0016J$\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u00102\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\f\u0010,\u001a\u00020\u001f*\u00020\u001fH\u0002J\f\u0010-\u001a\u00020\u0004*\u00020.H\u0002J\u0014\u0010/\u001a\u00020#*\u0002002\u0006\u00101\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00062"}, d2={"Landroidx/compose/material3/KotlinxDatetimeCalendarModel;", "Landroidx/compose/material3/CalendarModel;", "()V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "systemTZ", "Lkotlinx/datetime/TimeZone;", "getSystemTZ", "()Lkotlinx/datetime/TimeZone;", "today", "Landroidx/compose/material3/CalendarDate;", "getToday", "()Landroidx/compose/material3/CalendarDate;", "weekdayNames", "", "Lkotlin/Pair;", "", "getWeekdayNames", "()Ljava/util/List;", "formatWithPattern", "utcTimeMillis", "", "pattern", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "getCanonicalDate", "timeInMillis", "getDateInputFormat", "Landroidx/compose/material3/DateInputFormat;", "getDayOfWeek", "date", "getMonth", "Landroidx/compose/material3/CalendarMonth;", "year", "month", "minusMonths", "from", "subtractedMonthsCount", "parse", "plusMonths", "addedMonthsCount", "applyCalendarModelStyle", "daysFromStartOfWeekToFirstOfMonth", "Lkotlinx/datetime/LocalDate;", "toCalendarMonth", "Lkotlinx/datetime/Instant;", "timeZone", "material3"})
@SourceDebugExtension(value={"SMAP\nKotlinxDatetimeCalendarModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/KotlinxDatetimeCalendarModel\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n408#2,4:225\n384#2,4:229\n429#2:233\n502#2,5:234\n81#2,2:239\n1#3:241\n*S KotlinDebug\n*F\n+ 1 KotlinxDatetimeCalendarModel.kt\nandroidx/compose/material3/KotlinxDatetimeCalendarModel\n*L\n170#1:225,4\n171#1:229,4\n172#1:233\n172#1:234,5\n174#1:239,2\n*E\n"})
public final class KotlinxDatetimeCalendarModel
implements CalendarModel {
    @Override
    @NotNull
    public CalendarDate getToday() {
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(Clock.System.INSTANCE.now(), this.getSystemTZ());
    }

    @Override
    public int getFirstDayOfWeek() {
        return PlatformDateFormat.INSTANCE.getFirstDayOfWeek();
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getWeekdayNames() {
        return this.weekdayNames(ActualJvmKt.defaultLocale());
    }

    private final TimeZone getSystemTZ() {
        return TimeZone.Companion.currentSystemDefault();
    }

    @NotNull
    public final List<Pair<String, String>> weekdayNames(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        List list = PlatformDateFormat.INSTANCE.weekdayNames(locale);
        if (list == null) {
            list = KotlinxDatetimeCalendarModelKt.access$getEnglishWeekdaysNames$p();
        }
        return list;
    }

    @Override
    @NotNull
    public DateInputFormat getDateInputFormat(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.applyCalendarModelStyle(PlatformDateFormat.INSTANCE.getDateInputFormat(locale));
    }

    @Override
    @NotNull
    public CalendarDate getCanonicalDate(long timeInMillis) {
        return KotlinxDatetimeCalendarModelKt.toCalendarDate(TimeZoneKt.atStartOfDayIn((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(long timeInMillis) {
        return this.toCalendarMonth(Instant.Companion.fromEpochMilliseconds(timeInMillis), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getMonth(date.getUtcTimeMillis());
    }

    @Override
    @NotNull
    public CalendarMonth getMonth(int year, int month) {
        Instant instant = TimeZoneKt.atStartOfDayIn((LocalDate)new LocalDate(year, month, 1), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        return this.getMonth(instant.toEpochMilliseconds());
    }

    @Override
    public int getDayOfWeek(@NotNull CalendarDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return DayOfWeekKt.getIsoDayNumber((DayOfWeek)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(date.getUtcTimeMillis()), (TimeZone)this.getSystemTZ()).getDayOfWeek());
    }

    @Override
    @NotNull
    public CalendarMonth plusMonths(@NotNull CalendarMonth from, int addedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.toCalendarMonth(TimeZoneKt.atStartOfDayIn((LocalDate)LocalDateJvmKt.plus((LocalDate)TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(from.getStartUtcTimeMillis()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate(), (DatePeriod)new DatePeriod(0, addedMonthsCount, 0, 5, null)), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), (TimeZone)TimeZone.Companion.getUTC());
    }

    @Override
    @NotNull
    public CalendarMonth minusMonths(@NotNull CalendarMonth from, int subtractedMonthsCount) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.plusMonths(from, -subtractedMonthsCount);
    }

    @Override
    @NotNull
    public String formatWithPattern(long utcTimeMillis, @NotNull String pattern, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return PlatformDateFormat.INSTANCE.formatWithPattern(utcTimeMillis, pattern, locale);
    }

    @Override
    @Nullable
    public CalendarDate parse(@NotNull String date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return PlatformDateFormat.INSTANCE.parse(date, pattern);
    }

    private final CalendarMonth toCalendarMonth(Instant $this$toCalendarMonth, TimeZone timeZone) {
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)$this$toCalendarMonth, (TimeZone)timeZone);
        LocalDate monthStart = new LocalDate(dateTime.getYear(), dateTime.getMonth(), 1);
        return new CalendarMonth(dateTime.getYear(), dateTime.getMonthNumber(), KotlinxDatetimeCalendarModelKt.access$numberOfDays(dateTime.getMonth(), KotlinxDatetimeCalendarModelKt.access$isLeapYear(dateTime.getYear())), this.daysFromStartOfWeekToFirstOfMonth(monthStart), TimeZoneKt.atStartOfDayIn((LocalDate)monthStart, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
    }

    /*
     * WARNING - void declaration
     */
    private final DateInputFormat applyCalendarModelStyle(DateInputFormat $this$applyCalendarModelStyle) {
        char element$iv;
        String pattern;
        block11: {
            void $this$filterTo$iv$iv;
            String string;
            block10: {
                String string2;
                int n;
                int index$iv;
                block9: {
                    pattern = $this$applyCalendarModelStyle.getPatternWithDelimiters();
                    if (!StringsKt.contains((CharSequence)pattern, (CharSequence)"yyyy", (boolean)true)) {
                        while (StringsKt.contains((CharSequence)pattern, (CharSequence)"yy", (boolean)true)) {
                            pattern = StringsKt.replace((String)pattern, (String)"yy", (String)"y", (boolean)true);
                        }
                        pattern = StringsKt.replace((String)pattern, (String)"y", (String)"yyyy", (boolean)true);
                    }
                    if (!StringsKt.contains$default((CharSequence)pattern, (CharSequence)"MM", (boolean)false, (int)2, null)) {
                        pattern = StringsKt.replace$default((String)pattern, (String)"M", (String)"MM", (boolean)false, (int)4, null);
                    }
                    if (!StringsKt.contains$default((CharSequence)pattern, (CharSequence)"dd", (boolean)false, (int)2, null)) {
                        pattern = StringsKt.replace$default((String)pattern, (String)"d", (String)"dd", (boolean)false, (int)4, null);
                    }
                    String $this$dropWhile$iv = pattern;
                    boolean $i$f$dropWhile = false;
                    int n2 = $this$dropWhile$iv.length();
                    for (index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$dropWhile$iv.charAt(index$iv);
                        n = 0;
                        if (!Character.isLetter(it)) continue;
                        String string3 = $this$dropWhile$iv.substring(index$iv);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        break block9;
                    }
                    string2 = "";
                }
                String $this$dropLastWhile$iv = string2;
                boolean $i$f$dropLastWhile = false;
                for (index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it22 = $this$dropLastWhile$iv.charAt(index$iv);
                    int n3 = 0;
                    if (!Character.isLetter(it22)) continue;
                    String it22 = $this$dropLastWhile$iv;
                    n3 = 0;
                    n = index$iv + 1;
                    String string4 = it22.substring(n3, n);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block10;
                }
                string = "";
            }
            String $this$filter$iv = string;
            boolean $i$f$filter = false;
            CharSequence index$iv = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(it != ' ')) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string5 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"filterTo(StringBuilder(), predicate).toString()");
            pattern = string5;
            CharSequence $this$first$iv = pattern;
            boolean $i$f$first = false;
            for (int i = 0; i < $this$first$iv.length(); ++i) {
                char it = element$iv = $this$first$iv.charAt(i);
                boolean bl = false;
                if (!(!Character.isLetter(it))) {
                    continue;
                }
                break block11;
            }
            throw new NoSuchElementException("Char sequence contains no character matching the predicate.");
        }
        char delimiter = element$iv;
        return new DateInputFormat(pattern, delimiter);
    }

    private final int daysFromStartOfWeekToFirstOfMonth(LocalDate $this$daysFromStartOfWeekToFirstOfMonth) {
        int it = DayOfWeekKt.getIsoDayNumber((DayOfWeek)$this$daysFromStartOfWeekToFirstOfMonth.getDayOfWeek()) - this.getFirstDayOfWeek();
        boolean bl = false;
        return it > 0 ? it : 7 + it;
    }
}

