/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.pa() = mapOf(
    Strings.NavigationMenu to "ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ",
    Strings.ExposedDropdownMenu to "ਡ੍ਰੌਪ-ਡਾਊਨ ਮੀਨੂ",
    Strings.CloseDrawer to "ਨੈਵੀਗੇਸ਼ਨ ਮੀਨੂ ਬੰਦ ਕਰੋ",
    Strings.CloseSheet to "ਸ਼ੀਟ ਬੰਦ ਕਰੋ",
    Strings.DefaultErrorMessage to "ਅਵੈਧ ਇਨਪੁੱਟ",
    Strings.SliderRangeStart to "ਰੇਂਜ ਸ਼ੁਰੂ",
    Strings.SliderRangeEnd to "ਰੇਂਜ ਸਮਾਪਤ",
)
