/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.en() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Dropdown menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.SnackbarPaneTitle to "Alert",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enAU() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.SnackbarPaneTitle to "Alert",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enCA() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Dropdown menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.SnackbarPaneTitle to "Alert",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enGB() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.SnackbarPaneTitle to "Alert",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.enIN() = mapOf(
    Strings.NavigationMenu to "Navigation menu",
    Strings.ExposedDropdownMenu to "Drop-down menu",
    Strings.CloseDrawer to "Close navigation menu",
    Strings.CloseSheet to "Close sheet",
    Strings.DefaultErrorMessage to "Invalid input",
    Strings.SliderRangeStart to "Range start",
    Strings.SliderRangeEnd to "Range end",
    Strings.SnackbarPaneTitle to "Alert",
)
