/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SpatialAudioOff: ImageVector
    get() {
        if (_spatialAudioOff != null) {
            return _spatialAudioOff!!
        }
        _spatialAudioOff = materialIcon(name = "TwoTone.SpatialAudioOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.48f, 17.34f)
                curveTo(14.29f, 16.73f, 12.37f, 16.0f, 10.0f, 16.0f)
                curveToRelative(-2.37f, 0.0f, -4.29f, 0.73f, -5.48f, 1.34f)
                curveTo(4.2f, 17.5f, 4.0f, 17.84f, 4.0f, 18.22f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.78f)
                curveTo(16.0f, 17.84f, 15.8f, 17.5f, 15.48f, 17.34f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.0f, 9.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(10.0f, 13.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveTo(6.0f, 6.79f, 6.0f, 9.0f)
                curveTo(6.0f, 11.21f, 7.79f, 13.0f, 10.0f, 13.0f)
                close()
                moveTo(10.0f, 7.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                curveTo(8.0f, 7.9f, 8.9f, 7.0f, 10.0f, 7.0f)
                close()
            }
            materialPath {
                moveTo(16.39f, 15.56f)
                curveTo(14.71f, 14.7f, 12.53f, 14.0f, 10.0f, 14.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(2.61f, 16.07f, 2.0f, 17.1f, 2.0f, 18.22f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(18.0f, 17.1f, 17.39f, 16.07f, 16.39f, 15.56f)
                close()
                moveTo(16.0f, 19.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-0.78f)
                curveToRelative(0.0f, -0.38f, 0.2f, -0.72f, 0.52f, -0.88f)
                curveTo(5.71f, 16.73f, 7.63f, 16.0f, 10.0f, 16.0f)
                curveToRelative(2.37f, 0.0f, 4.29f, 0.73f, 5.48f, 1.34f)
                curveTo(15.8f, 17.5f, 16.0f, 17.84f, 16.0f, 18.22f)
                verticalLineTo(19.0f)
                close()
            }
            materialPath {
                moveTo(20.36f, 1.0f)
                lineToRelative(-1.41f, 1.41f)
                curveToRelative(2.73f, 2.73f, 2.73f, 7.17f, 0.0f, 9.9f)
                lineToRelative(1.41f, 1.41f)
                curveTo(23.88f, 10.21f, 23.88f, 4.51f, 20.36f, 1.0f)
                close()
            }
            materialPath {
                moveTo(17.54f, 10.9f)
                curveToRelative(1.95f, -1.95f, 1.95f, -5.12f, 0.0f, -7.07f)
                lineToRelative(-1.41f, 1.41f)
                curveToRelative(1.17f, 1.17f, 1.17f, 3.07f, 0.0f, 4.24f)
                lineTo(17.54f, 10.9f)
                close()
            }
        }
        return _spatialAudioOff!!
    }

private var _spatialAudioOff: ImageVector? = null
