/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoCell: ImageVector
    get() {
        if (_noCell != null) {
            return _noCell!!
        }
        _noCell = materialIcon(name = "Sharp.NoCell") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(23.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(0.78f, 0.78f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(7.0f, 18.0f)
                verticalLineTo(9.83f)
                lineTo(15.17f, 18.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(8.83f, 6.0f)
                lineTo(5.0f, 2.17f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(15.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                close()
            }
        }
        return _noCell!!
    }

private var _noCell: ImageVector? = null
