/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.InstallDesktop: ImageVector
    get() {
        if (_installDesktop != null) {
            return _installDesktop!!
        }
        _installDesktop = materialIcon(name = "Sharp.InstallDesktop") {
            materialPath {
                moveTo(20.0f, 17.0f)
                lineToRelative(-16.0f, 0.0f)
                lineToRelative(0.0f, -12.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-10.0f, 0.0f)
                lineToRelative(0.0f, 16.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(-2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 14.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-2.59f, 2.58f)
                lineToRelative(0.0f, -7.17f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 7.17f)
                lineToRelative(-2.59f, -2.58f)
                lineToRelative(-1.41f, 1.41f)
                close()
            }
        }
        return _installDesktop!!
    }

private var _installDesktop: ImageVector? = null
