/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.InsertDriveFile",
    ReplaceWith( "Icons.AutoMirrored.Sharp.InsertDriveFile",
            "androidx.compose.material.icons.automirrored.sharp.InsertDriveFile"),
)
public val Icons.Sharp.InsertDriveFile: ImageVector
    get() {
        if (_insertDriveFile != null) {
            return _insertDriveFile!!
        }
        _insertDriveFile = materialIcon(name = "Sharp.InsertDriveFile") {
            materialPath {
                moveTo(4.01f, 2.0f)
                lineTo(4.0f, 22.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(8.0f)
                lineToRelative(-6.0f, -6.0f)
                horizontalLineTo(4.01f)
                close()
                moveTo(13.0f, 9.0f)
                verticalLineTo(3.5f)
                lineTo(18.5f, 9.0f)
                horizontalLineTo(13.0f)
                close()
            }
        }
        return _insertDriveFile!!
    }

private var _insertDriveFile: ImageVector? = null
