/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ChildFriendly: ImageVector
    get() {
        if (_childFriendly != null) {
            return _childFriendly!!
        }
        _childFriendly = materialIcon(name = "Sharp.ChildFriendly") {
            materialPath {
                moveTo(13.0f, 2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(0.0f, -4.42f, -3.58f, -8.0f, -8.0f, -8.0f)
                close()
                moveTo(19.32f, 15.89f)
                curveTo(20.37f, 14.54f, 21.0f, 12.84f, 21.0f, 11.0f)
                lineTo(6.44f, 11.0f)
                lineToRelative(-0.95f, -2.0f)
                lineTo(2.0f, 9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.22f)
                reflectiveCurveToRelative(1.89f, 4.07f, 2.12f, 4.42f)
                curveToRelative(-1.1f, 0.59f, -1.84f, 1.75f, -1.84f, 3.08f)
                curveTo(4.5f, 20.43f, 6.07f, 22.0f, 8.0f, 22.0f)
                curveToRelative(1.76f, 0.0f, 3.22f, -1.3f, 3.46f, -3.0f)
                horizontalLineToRelative(2.08f)
                curveToRelative(0.24f, 1.7f, 1.7f, 3.0f, 3.46f, 3.0f)
                curveToRelative(1.93f, 0.0f, 3.5f, -1.57f, 3.5f, -3.5f)
                curveToRelative(0.0f, -1.04f, -0.46f, -1.97f, -1.18f, -2.61f)
                close()
                moveTo(8.0f, 20.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveTo(7.17f, 17.0f, 8.0f, 17.0f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(8.83f, 20.0f, 8.0f, 20.0f)
                close()
                moveTo(17.0f, 20.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveTo(16.17f, 17.0f, 17.0f, 17.0f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(17.83f, 20.0f, 17.0f, 20.0f)
                close()
            }
        }
        return _childFriendly!!
    }

private var _childFriendly: ImageVector? = null
