/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.StarPurple500: ImageVector
    get() {
        if (_starPurple500 != null) {
            return _starPurple500!!
        }
        _starPurple500 = materialIcon(name = "Rounded.StarPurple500") {
            materialPath {
                moveTo(12.0f, 8.89f)
                lineTo(12.94f, 12.0f)
                horizontalLineToRelative(2.82f)
                lineToRelative(-2.27f, 1.62f)
                lineToRelative(0.93f, 3.01f)
                lineTo(12.0f, 14.79f)
                lineToRelative(-2.42f, 1.84f)
                lineToRelative(0.93f, -3.01f)
                lineTo(8.24f, 12.0f)
                horizontalLineToRelative(2.82f)
                lineTo(12.0f, 8.89f)
                moveTo(9.58f, 10.0f)
                horizontalLineTo(5.12f)
                curveToRelative(-0.97f, 0.0f, -1.37f, 1.25f, -0.58f, 1.81f)
                lineToRelative(3.64f, 2.6f)
                lineToRelative(-1.43f, 4.61f)
                curveToRelative(-0.29f, 0.93f, 0.79f, 1.68f, 1.56f, 1.09f)
                lineTo(12.0f, 17.31f)
                lineToRelative(3.69f, 2.81f)
                curveToRelative(0.77f, 0.59f, 1.85f, -0.16f, 1.56f, -1.09f)
                lineToRelative(-1.43f, -4.61f)
                lineToRelative(3.64f, -2.6f)
                curveToRelative(0.79f, -0.57f, 0.39f, -1.81f, -0.58f, -1.81f)
                horizontalLineToRelative(-4.46f)
                lineToRelative(-1.47f, -4.84f)
                curveToRelative(-0.29f, -0.95f, -1.63f, -0.95f, -1.91f, 0.0f)
                lineTo(9.58f, 10.0f)
                close()
            }
        }
        return _starPurple500!!
    }

private var _starPurple500: ImageVector? = null
