/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PianoOff: ImageVector
    get() {
        if (_pianoOff != null) {
            return _pianoOff!!
        }
        _pianoOff = materialIcon(name = "Rounded.PianoOff") {
            materialPath {
                moveTo(20.49f, 21.9f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(3.51f, 3.51f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(3.0f, 5.83f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(0.9f, 0.9f)
                curveTo(19.46f, 22.29f, 20.09f, 22.29f, 20.49f, 21.9f)
                close()
                moveTo(8.25f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.83f)
                lineToRelative(2.0f, 2.0f)
                verticalLineToRelative(3.67f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.25f)
                verticalLineTo(19.0f)
                close()
                moveTo(9.75f, 19.0f)
                verticalLineToRelative(-4.5f)
                horizontalLineTo(10.0f)
                curveToRelative(0.46f, 0.0f, 0.82f, -0.31f, 0.94f, -0.73f)
                lineToRelative(3.31f, 3.31f)
                verticalLineTo(19.0f)
                horizontalLineTo(9.75f)
                close()
                moveTo(11.0f, 8.17f)
                lineTo(5.83f, 3.0f)
                horizontalLineTo(19.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(13.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(8.5f)
                curveToRelative(0.0f, 0.19f, -0.07f, 0.36f, -0.16f, 0.51f)
                lineTo(13.0f, 10.17f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(8.17f)
                close()
            }
        }
        return _pianoOff!!
    }

private var _pianoOff: ImageVector? = null
