/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NoiseAware: ImageVector
    get() {
        if (_noiseAware != null) {
            return _noiseAware!!
        }
        _noiseAware = materialIcon(name = "Rounded.NoiseAware") {
            materialPath {
                moveTo(15.62f, 16.45f)
                curveToRelative(0.36f, -0.65f, -0.15f, -1.45f, -0.9f, -1.45f)
                curveToRelative(-0.34f, 0.0f, -0.68f, 0.16f, -0.84f, 0.47f)
                curveTo(13.72f, 15.78f, 13.38f, 16.0f, 13.0f, 16.0f)
                curveToRelative(-0.43f, 0.0f, -0.81f, -0.27f, -0.95f, -0.68f)
                curveToRelative(-0.15f, -0.44f, -0.4f, -1.08f, -0.93f, -1.61f)
                lineToRelative(-1.36f, -1.36f)
                curveTo(9.28f, 11.87f, 9.0f, 11.19f, 9.0f, 10.5f)
                curveTo(9.0f, 9.12f, 10.12f, 8.0f, 11.5f, 8.0f)
                curveToRelative(0.98f, 0.0f, 1.84f, 0.57f, 2.24f, 1.4f)
                curveToRelative(0.18f, 0.36f, 0.52f, 0.6f, 0.91f, 0.6f)
                curveToRelative(0.75f, 0.0f, 1.22f, -0.79f, 0.89f, -1.46f)
                curveTo(14.82f, 7.04f, 13.28f, 6.0f, 11.5f, 6.0f)
                curveToRelative(-2.89f, 0.0f, -5.15f, 2.74f, -4.33f, 5.76f)
                curveToRelative(0.22f, 0.8f, 0.68f, 1.51f, 1.27f, 2.1f)
                lineToRelative(1.27f, 1.27f)
                curveToRelative(0.15f, 0.16f, 0.28f, 0.38f, 0.4f, 0.71f)
                curveToRelative(0.41f, 1.13f, 1.38f, 2.04f, 2.58f, 2.16f)
                curveTo(13.95f, 18.11f, 15.07f, 17.46f, 15.62f, 16.45f)
                close()
            }
            materialPath {
                moveTo(13.5f, 12.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 3.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 21.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(5.75f, 7.01f)
                curveToRelative(0.34f, -0.43f, 0.27f, -1.06f, -0.16f, -1.41f)
                curveTo(5.16f, 5.26f, 4.53f, 5.33f, 4.18f, 5.77f)
                curveTo(3.84f, 6.2f, 3.91f, 6.83f, 4.34f, 7.17f)
                curveTo(4.77f, 7.51f, 5.4f, 7.44f, 5.75f, 7.01f)
                close()
            }
            materialPath {
                moveTo(18.25f, 16.99f)
                curveToRelative(-0.34f, 0.43f, -0.27f, 1.06f, 0.16f, 1.41f)
                reflectiveCurveToRelative(1.06f, 0.27f, 1.41f, -0.16f)
                curveToRelative(0.34f, -0.43f, 0.27f, -1.06f, -0.16f, -1.41f)
                curveTo(19.23f, 16.49f, 18.6f, 16.56f, 18.25f, 16.99f)
                close()
            }
            materialPath {
                moveTo(4.2f, 13.78f)
                curveToRelative(-0.12f, -0.54f, -0.66f, -0.88f, -1.2f, -0.75f)
                reflectiveCurveToRelative(-0.88f, 0.66f, -0.75f, 1.2f)
                curveToRelative(0.12f, 0.54f, 0.66f, 0.88f, 1.2f, 0.75f)
                curveTo(3.99f, 14.86f, 4.32f, 14.32f, 4.2f, 13.78f)
                close()
            }
            materialPath {
                moveTo(19.8f, 10.22f)
                curveToRelative(0.12f, 0.54f, 0.66f, 0.88f, 1.2f, 0.75f)
                reflectiveCurveToRelative(0.88f, -0.66f, 0.75f, -1.2f)
                reflectiveCurveToRelative(-0.66f, -0.88f, -1.2f, -0.75f)
                curveTo(20.01f, 9.14f, 19.68f, 9.68f, 19.8f, 10.22f)
                close()
            }
            materialPath {
                moveTo(8.53f, 19.21f)
                curveToRelative(-0.5f, -0.24f, -1.1f, -0.03f, -1.33f, 0.47f)
                curveToRelative(-0.24f, 0.5f, -0.03f, 1.1f, 0.47f, 1.33f)
                curveToRelative(0.5f, 0.24f, 1.1f, 0.03f, 1.33f, -0.47f)
                curveTo(9.24f, 20.05f, 9.03f, 19.45f, 8.53f, 19.21f)
                close()
            }
            materialPath {
                moveTo(15.47f, 4.79f)
                curveToRelative(0.5f, 0.24f, 1.1f, 0.03f, 1.33f, -0.47f)
                curveToRelative(0.24f, -0.5f, 0.03f, -1.1f, -0.47f, -1.33f)
                curveToRelative(-0.5f, -0.24f, -1.1f, -0.03f, -1.33f, 0.47f)
                curveTo(14.76f, 3.95f, 14.97f, 4.55f, 15.47f, 4.79f)
                close()
            }
            materialPath {
                moveTo(15.47f, 19.21f)
                curveToRelative(-0.5f, 0.24f, -0.71f, 0.84f, -0.47f, 1.33f)
                reflectiveCurveToRelative(0.84f, 0.71f, 1.33f, 0.47f)
                curveToRelative(0.5f, -0.24f, 0.71f, -0.84f, 0.47f, -1.33f)
                curveTo(16.57f, 19.18f, 15.97f, 18.97f, 15.47f, 19.21f)
                close()
            }
            materialPath {
                moveTo(8.53f, 4.79f)
                curveTo(9.03f, 4.55f, 9.23f, 3.96f, 9.0f, 3.46f)
                curveToRelative(-0.24f, -0.5f, -0.84f, -0.71f, -1.33f, -0.47f)
                reflectiveCurveTo(6.95f, 3.83f, 7.19f, 4.33f)
                reflectiveCurveTo(8.03f, 5.03f, 8.53f, 4.79f)
                close()
            }
            materialPath {
                moveTo(21.0f, 13.03f)
                curveToRelative(-0.54f, -0.12f, -1.07f, 0.21f, -1.2f, 0.75f)
                curveToRelative(-0.12f, 0.54f, 0.21f, 1.07f, 0.75f, 1.2f)
                curveToRelative(0.54f, 0.12f, 1.07f, -0.21f, 1.2f, -0.75f)
                curveTo(21.87f, 13.69f, 21.54f, 13.15f, 21.0f, 13.03f)
                close()
            }
            materialPath {
                moveTo(3.0f, 10.97f)
                curveToRelative(0.54f, 0.12f, 1.07f, -0.21f, 1.2f, -0.75f)
                curveToRelative(0.12f, -0.54f, -0.21f, -1.07f, -0.75f, -1.2f)
                reflectiveCurveToRelative(-1.07f, 0.21f, -1.2f, 0.75f)
                curveTo(2.13f, 10.31f, 2.46f, 10.85f, 3.0f, 10.97f)
                close()
            }
            materialPath {
                moveTo(19.66f, 7.17f)
                curveToRelative(0.43f, -0.34f, 0.5f, -0.97f, 0.16f, -1.41f)
                reflectiveCurveToRelative(-0.97f, -0.5f, -1.41f, -0.16f)
                curveToRelative(-0.43f, 0.34f, -0.5f, 0.97f, -0.16f, 1.41f)
                curveTo(18.6f, 7.44f, 19.23f, 7.51f, 19.66f, 7.17f)
                close()
            }
            materialPath {
                moveTo(4.34f, 16.83f)
                curveToRelative(-0.43f, 0.34f, -0.5f, 0.97f, -0.16f, 1.41f)
                curveToRelative(0.34f, 0.43f, 0.97f, 0.5f, 1.41f, 0.16f)
                curveToRelative(0.43f, -0.34f, 0.5f, -0.97f, 0.16f, -1.41f)
                reflectiveCurveTo(4.77f, 16.49f, 4.34f, 16.83f)
                close()
            }
        }
        return _noiseAware!!
    }

private var _noiseAware: ImageVector? = null
