/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FilterListOff: ImageVector
    get() {
        if (_filterListOff != null) {
            return _filterListOff!!
        }
        _filterListOff = materialIcon(name = "Rounded.FilterListOff") {
            materialPath {
                moveTo(21.0f, 7.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(8.83f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(20.0f)
                curveTo(20.55f, 8.0f, 21.0f, 7.55f, 21.0f, 7.0f)
                close()
                moveTo(18.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(17.0f)
                curveTo(17.55f, 13.0f, 18.0f, 12.55f, 18.0f, 12.0f)
                close()
                moveTo(13.98f, 16.81f)
                curveTo(13.99f, 16.87f, 14.0f, 16.94f, 14.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.06f, 0.0f, 0.13f, 0.01f, 0.19f, 0.02f)
                lineTo(10.17f, 13.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(1.17f)
                lineToRelative(-3.0f, -3.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 8.0f, 3.0f, 7.55f, 3.0f, 7.0f)
                curveToRelative(0.0f, -0.32f, 0.15f, -0.6f, 0.38f, -0.79f)
                lineTo(2.1f, 4.93f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                reflectiveCurveToRelative(1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(16.97f, 16.97f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.02f, 0.0f, 1.41f)
                reflectiveCurveToRelative(-1.02f, 0.39f, -1.41f, 0.0f)
                lineTo(13.98f, 16.81f)
                close()
            }
        }
        return _filterListOff!!
    }

private var _filterListOff: ImageVector? = null
