/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.EmergencyShare: ImageVector
    get() {
        if (_emergencyShare != null) {
            return _emergencyShare!!
        }
        _emergencyShare = materialIcon(name = "Rounded.EmergencyShare") {
            materialPath {
                moveTo(12.0f, 9.0f)
                curveToRelative(-3.15f, 0.0f, -6.0f, 2.41f, -6.0f, 6.15f)
                curveToRelative(0.0f, 2.35f, 1.78f, 5.11f, 5.34f, 8.27f)
                curveToRelative(0.37f, 0.33f, 0.95f, 0.33f, 1.33f, 0.0f)
                curveTo(16.22f, 20.25f, 18.0f, 17.5f, 18.0f, 15.15f)
                curveTo(18.0f, 11.41f, 15.15f, 9.0f, 12.0f, 9.0f)
                close()
                moveTo(12.0f, 16.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(12.83f, 16.5f, 12.0f, 16.5f)
                close()
                moveTo(16.18f, 6.82f)
                curveToRelative(-0.35f, 0.35f, -0.89f, 0.38f, -1.3f, 0.09f)
                curveTo(14.07f, 6.34f, 13.07f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveTo(9.93f, 6.34f, 9.12f, 6.91f)
                curveToRelative(-0.41f, 0.28f, -0.95f, 0.26f, -1.3f, -0.09f)
                curveToRelative(-0.43f, -0.43f, -0.39f, -1.15f, 0.09f, -1.5f)
                curveTo(9.06f, 4.49f, 10.48f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(2.94f, 0.49f, 4.09f, 1.32f)
                curveTo(16.58f, 5.67f, 16.61f, 6.39f, 16.18f, 6.82f)
                close()
                moveTo(4.97f, 3.97f)
                curveTo(4.55f, 3.54f, 4.59f, 2.85f, 5.05f, 2.47f)
                curveTo(6.95f, 0.93f, 9.37f, 0.0f, 12.01f, 0.0f)
                curveToRelative(2.64f, 0.0f, 5.06f, 0.93f, 6.95f, 2.48f)
                curveToRelative(0.46f, 0.38f, 0.5f, 1.07f, 0.08f, 1.49f)
                curveToRelative(-0.36f, 0.36f, -0.93f, 0.39f, -1.32f, 0.07f)
                curveTo(16.16f, 2.77f, 14.17f, 2.0f, 12.01f, 2.0f)
                curveTo(9.83f, 2.0f, 7.84f, 2.77f, 6.29f, 4.04f)
                curveTo(5.9f, 4.36f, 5.33f, 4.32f, 4.97f, 3.97f)
                close()
            }
        }
        return _emergencyShare!!
    }

private var _emergencyShare: ImageVector? = null
