/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SignalCellular0Bar: ImageVector
    get() {
        if (_signalCellular0Bar != null) {
            return _signalCellular0Bar!!
        }
        _signalCellular0Bar = materialIcon(name = "Outlined.SignalCellular0Bar") {
            materialPath {
                moveTo(2.0f, 22.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                lineTo(2.0f, 22.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineTo(6.83f)
                lineTo(20.0f, 6.83f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _signalCellular0Bar!!
    }

private var _signalCellular0Bar: ImageVector? = null
