/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Rocket: ImageVector
    get() {
        if (_rocket != null) {
            return _rocket!!
        }
        _rocket = materialIcon(name = "Outlined.Rocket") {
            materialPath {
                moveTo(14.0f, 11.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveTo(14.0f, 12.1f, 14.0f, 11.0f)
                close()
                moveTo(7.98f, 18.25f)
                curveToRelative(-0.29f, -0.9f, -0.57f, -1.94f, -0.76f, -3.0f)
                lineTo(6.0f, 16.07f)
                verticalLineToRelative(2.98f)
                lineTo(7.98f, 18.25f)
                close()
                moveTo(12.0f, 2.0f)
                curveToRelative(0.0f, 0.0f, 5.0f, 2.0f, 5.0f, 11.0f)
                lineToRelative(2.11f, 1.41f)
                curveToRelative(0.56f, 0.37f, 0.89f, 1.0f, 0.89f, 1.66f)
                verticalLineTo(22.0f)
                lineToRelative(-5.0f, -2.0f)
                horizontalLineTo(9.0f)
                lineToRelative(-5.0f, 2.0f)
                verticalLineToRelative(-5.93f)
                curveToRelative(0.0f, -0.67f, 0.33f, -1.29f, 0.89f, -1.66f)
                lineTo(7.0f, 13.0f)
                curveTo(7.0f, 4.0f, 12.0f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 4.36f)
                curveToRelative(0.0f, 0.0f, -3.0f, 2.02f, -3.0f, 8.64f)
                curveToRelative(0.0f, 2.25f, 1.0f, 5.0f, 1.0f, 5.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.0f, 1.0f, -2.75f, 1.0f, -5.0f)
                curveTo(15.0f, 6.38f, 12.0f, 4.36f, 12.0f, 4.36f)
                close()
                moveTo(18.0f, 19.05f)
                verticalLineToRelative(-2.98f)
                lineToRelative(-1.22f, -0.81f)
                curveToRelative(-0.19f, 1.05f, -0.47f, 2.1f, -0.76f, 3.0f)
                lineTo(18.0f, 19.05f)
                close()
            }
        }
        return _rocket!!
    }

private var _rocket: ImageVector? = null
