/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PestControlRodent: ImageVector
    get() {
        if (_pestControlRodent != null) {
            return _pestControlRodent!!
        }
        _pestControlRodent = materialIcon(name = "Outlined.PestControlRodent") {
            materialPath {
                moveTo(17.0f, 17.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(20.86f, 14.97f)
                lineToRelative(-0.93f, -0.84f)
                curveToRelative(0.48f, -3.45f, -2.87f, -6.04f, -6.05f, -4.82f)
                curveTo(13.3f, 9.11f, 12.66f, 9.0f, 12.0f, 9.0f)
                curveToRelative(-4.26f, 0.0f, -5.65f, 3.58f, -5.89f, 4.85f)
                curveTo(4.89f, 13.47f, 4.0f, 12.35f, 4.0f, 11.0f)
                curveToRelative(0.0f, -1.66f, 1.34f, -3.0f, 3.0f, -3.0f)
                horizontalLineToRelative(2.5f)
                curveTo(10.88f, 8.0f, 12.0f, 6.88f, 12.0f, 5.5f)
                curveTo(12.0f, 4.12f, 10.88f, 3.0f, 9.5f, 3.0f)
                horizontalLineTo(8.0f)
                curveTo(7.45f, 3.0f, 7.0f, 3.45f, 7.0f, 4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.5f)
                curveTo(9.78f, 5.0f, 10.0f, 5.22f, 10.0f, 5.5f)
                curveTo(10.0f, 5.78f, 9.78f, 6.0f, 9.5f, 6.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                curveToRelative(0.0f, 2.44f, 1.76f, 4.47f, 4.07f, 4.91f)
                curveTo(6.51f, 18.79f, 8.99f, 21.0f, 12.0f, 21.0f)
                horizontalLineToRelative(6.53f)
                curveTo(21.64f, 21.0f, 23.23f, 17.11f, 20.86f, 14.97f)
                close()
                moveTo(18.53f, 19.0f)
                horizontalLineTo(12.0f)
                curveToRelative(-1.21f, 0.0f, -2.34f, -0.54f, -3.11f, -1.48f)
                curveToRelative(-0.78f, -0.95f, -1.06f, -2.16f, -0.8f, -3.41f)
                curveToRelative(0.31f, -1.48f, 1.51f, -2.69f, 2.99f, -3.01f)
                curveToRelative(0.22f, -0.05f, 0.45f, -0.06f, 0.67f, -0.07f)
                curveTo(11.28f, 11.74f, 11.0f, 12.58f, 11.0f, 13.5f)
                curveToRelative(0.0f, 1.24f, 0.5f, 2.37f, 1.32f, 3.18f)
                lineToRelative(1.41f, -1.41f)
                curveTo(13.28f, 14.82f, 13.0f, 14.19f, 13.0f, 13.5f)
                curveToRelative(0.0f, -1.42f, 1.2f, -2.5f, 2.5f, -2.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.12f, 2.5f, 2.5f)
                curveToRelative(0.0f, 0.46f, -0.13f, 0.88f, -0.35f, 1.25f)
                lineToRelative(1.87f, 1.7f)
                curveToRelative(0.31f, 0.28f, 0.48f, 0.67f, 0.48f, 1.09f)
                curveTo(20.0f, 18.34f, 19.34f, 19.0f, 18.53f, 19.0f)
                close()
            }
        }
        return _pestControlRodent!!
    }

private var _pestControlRodent: ImageVector? = null
