/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Lyrics: ImageVector
    get() {
        if (_lyrics != null) {
            return _lyrics!!
        }
        _lyrics = materialIcon(name = "Outlined.Lyrics") {
            materialPath {
                moveTo(6.0f, 6.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-7.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 12.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 11.97f)
                verticalLineTo(16.0f)
                horizontalLineTo(6.0f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(2.03f)
                curveToRelative(0.52f, -0.69f, 1.2f, -1.25f, 2.0f, -1.6f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.01f, 2.9f, 2.01f, 4.0f)
                lineTo(2.0f, 22.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-2.42f)
                curveTo(16.2f, 13.22f, 15.52f, 12.66f, 15.0f, 11.97f)
                close()
            }
            materialPath {
                moveTo(6.0f, 9.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-7.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 6.18f)
                curveTo(19.69f, 6.07f, 19.35f, 6.0f, 19.0f, 6.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(6.18f)
                close()
            }
        }
        return _lyrics!!
    }

private var _lyrics: ImageVector? = null
