/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.EmojiNature: ImageVector
    get() {
        if (_emojiNature != null) {
            return _emojiNature!!
        }
        _emojiNature = materialIcon(name = "Outlined.EmojiNature") {
            materialPath {
                moveTo(21.94f, 4.88f)
                curveTo(21.76f, 4.35f, 21.25f, 4.0f, 20.68f, 4.0f)
                curveToRelative(-0.03f, 0.0f, -0.06f, 0.0f, -0.09f, 0.0f)
                horizontalLineTo(19.6f)
                lineToRelative(-0.31f, -0.97f)
                curveTo(19.15f, 2.43f, 18.61f, 2.0f, 18.0f, 2.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.61f, 0.0f, -1.15f, 0.43f, -1.29f, 1.04f)
                lineTo(16.4f, 4.0f)
                horizontalLineToRelative(-0.98f)
                curveToRelative(-0.03f, 0.0f, -0.06f, 0.0f, -0.09f, 0.0f)
                curveToRelative(-0.57f, 0.0f, -1.08f, 0.35f, -1.26f, 0.88f)
                curveToRelative(-0.19f, 0.56f, 0.04f, 1.17f, 0.56f, 1.48f)
                lineToRelative(0.87f, 0.52f)
                lineTo(15.1f, 8.12f)
                curveToRelative(-0.23f, 0.58f, -0.04f, 1.25f, 0.45f, 1.62f)
                curveTo(15.78f, 9.91f, 16.06f, 10.0f, 16.33f, 10.0f)
                curveToRelative(0.31f, 0.0f, 0.61f, -0.11f, 0.86f, -0.32f)
                lineTo(18.0f, 8.98f)
                lineToRelative(0.81f, 0.7f)
                curveTo(19.06f, 9.89f, 19.36f, 10.0f, 19.67f, 10.0f)
                curveToRelative(0.27f, 0.0f, 0.55f, -0.09f, 0.78f, -0.26f)
                curveToRelative(0.5f, -0.37f, 0.68f, -1.04f, 0.45f, -1.62f)
                lineToRelative(-0.39f, -1.24f)
                lineToRelative(0.87f, -0.52f)
                curveTo(21.89f, 6.05f, 22.12f, 5.44f, 21.94f, 4.88f)
                close()
                moveTo(18.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(19.0f, 6.55f, 18.55f, 7.0f, 18.0f, 7.0f)
                close()
            }
            materialPath {
                moveTo(13.49f, 10.51f)
                curveToRelative(-0.43f, -0.43f, -0.94f, -0.73f, -1.49f, -0.93f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.38f)
                curveToRelative(-0.11f, -0.01f, -0.23f, -0.03f, -0.34f, -0.03f)
                curveToRelative(-1.02f, 0.0f, -2.05f, 0.39f, -2.83f, 1.17f)
                curveToRelative(-0.12f, 0.12f, -0.3f, 0.3f, -0.5f, 0.5f)
                lineTo(6.0f, 10.52f)
                curveToRelative(-1.56f, -0.55f, -3.28f, 0.27f, -3.83f, 1.82f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveToRelative(-0.27f, 0.75f, -0.23f, 1.57f, 0.12f, 2.29f)
                curveToRelative(0.23f, 0.48f, 0.58f, 0.87f, 1.0f, 1.16f)
                curveToRelative(-0.38f, 1.35f, -0.06f, 2.85f, 1.0f, 3.91f)
                curveToRelative(0.78f, 0.78f, 1.8f, 1.17f, 2.83f, 1.17f)
                curveToRelative(0.37f, 0.0f, 0.73f, -0.07f, 1.09f, -0.17f)
                curveToRelative(0.29f, 0.42f, 0.68f, 0.77f, 1.16f, 1.0f)
                curveTo(9.78f, 21.9f, 10.21f, 22.0f, 10.65f, 22.0f)
                curveToRelative(0.34f, 0.0f, 0.68f, -0.06f, 1.01f, -0.17f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveToRelative(1.56f, -0.55f, 2.38f, -2.27f, 1.82f, -3.85f)
                lineToRelative(-0.49f, -1.3f)
                curveToRelative(0.2f, -0.2f, 0.38f, -0.38f, 0.5f, -0.5f)
                curveToRelative(0.87f, -0.87f, 1.24f, -2.04f, 1.14f, -3.17f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-1.59f)
                curveTo(14.22f, 11.46f, 13.92f, 10.95f, 13.49f, 10.51f)
                close()
                moveTo(7.58f, 18.82f)
                curveToRelative(-0.15f, 0.04f, -0.3f, 0.06f, -0.46f, 0.06f)
                curveToRelative(-0.53f, 0.0f, -1.04f, -0.21f, -1.41f, -0.59f)
                curveToRelative(-0.38f, -0.38f, -0.59f, -0.88f, -0.59f, -1.41f)
                curveToRelative(0.0f, -0.16f, 0.03f, -0.32f, 0.06f, -0.47f)
                curveToRelative(0.14f, 0.01f, 0.28f, 0.03f, 0.42f, 0.03f)
                curveToRelative(0.85f, 0.0f, 1.68f, -0.2f, 2.44f, -0.48f)
                curveTo(7.72f, 16.85f, 7.5f, 17.83f, 7.58f, 18.82f)
                close()
                moveTo(4.67f, 14.29f)
                curveToRelative(-0.25f, -0.09f, -0.45f, -0.27f, -0.57f, -0.51f)
                reflectiveCurveToRelative(-0.13f, -0.51f, -0.04f, -0.76f)
                curveToRelative(0.19f, -0.52f, 0.76f, -0.79f, 1.26f, -0.61f)
                lineToRelative(3.16f, 1.19f)
                curveTo(7.33f, 14.2f, 5.85f, 14.71f, 4.67f, 14.29f)
                close()
                moveTo(10.99f, 19.94f)
                curveToRelative(-0.25f, 0.09f, -0.52f, 0.08f, -0.76f, -0.04f)
                curveToRelative(-0.24f, -0.11f, -0.42f, -0.32f, -0.51f, -0.57f)
                curveToRelative(-0.42f, -1.18f, 0.09f, -2.65f, 0.7f, -3.8f)
                lineToRelative(1.18f, 3.13f)
                curveTo(11.78f, 19.18f, 11.51f, 19.76f, 10.99f, 19.94f)
                close()
                moveTo(12.2f, 14.6f)
                lineToRelative(-0.61f, -1.61f)
                curveToRelative(0.0f, -0.01f, -0.01f, -0.02f, -0.02f, -0.03f)
                curveToRelative(-0.02f, -0.04f, -0.04f, -0.08f, -0.06f, -0.12f)
                curveToRelative(-0.02f, -0.04f, -0.04f, -0.07f, -0.07f, -0.11f)
                curveToRelative(-0.03f, -0.03f, -0.06f, -0.06f, -0.09f, -0.09f)
                curveToRelative(-0.03f, -0.03f, -0.06f, -0.06f, -0.09f, -0.09f)
                curveToRelative(-0.03f, -0.03f, -0.07f, -0.05f, -0.11f, -0.07f)
                curveToRelative(-0.04f, -0.02f, -0.07f, -0.05f, -0.12f, -0.06f)
                curveToRelative(-0.01f, 0.0f, -0.02f, -0.01f, -0.03f, -0.02f)
                lineTo(9.4f, 11.8f)
                curveToRelative(0.36f, -0.29f, 0.79f, -0.46f, 1.26f, -0.46f)
                curveToRelative(0.53f, 0.0f, 1.04f, 0.21f, 1.41f, 0.59f)
                curveTo(12.8f, 12.66f, 12.84f, 13.81f, 12.2f, 14.6f)
                close()
            }
        }
        return _emojiNature!!
    }

private var _emojiNature: ImageVector? = null
