/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Volcano: ImageVector
    get() {
        if (_volcano != null) {
            return _volcano!!
        }
        _volcano = materialIcon(name = "Filled.Volcano") {
            materialPath {
                moveTo(18.0f, 8.0f)
                lineToRelative(-7.0f, 0.0f)
                lineToRelative(-2.0f, 5.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(-4.0f, 9.0f)
                lineToRelative(20.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(16.121f, 5.468f)
                lineToRelative(2.828f, -2.828f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-2.828f, 2.828f)
                close()
            }
            materialPath {
                moveTo(7.64f, 4.05f)
                lineToRelative(1.414f, -1.414f)
                lineToRelative(2.828f, 2.828f)
                lineToRelative(-1.414f, 1.414f)
                close()
            }
        }
        return _volcano!!
    }

private var _volcano: ImageVector? = null
