/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SlowMotionVideo: ImageVector
    get() {
        if (_slowMotionVideo != null) {
            return _slowMotionVideo!!
        }
        _slowMotionVideo = materialIcon(name = "Filled.SlowMotionVideo") {
            materialPath {
                moveTo(13.05f, 9.79f)
                lineTo(10.0f, 7.5f)
                verticalLineToRelative(9.0f)
                lineToRelative(3.05f, -2.29f)
                lineTo(16.0f, 12.0f)
                close()
                moveTo(13.05f, 9.79f)
                lineTo(10.0f, 7.5f)
                verticalLineToRelative(9.0f)
                lineToRelative(3.05f, -2.29f)
                lineTo(16.0f, 12.0f)
                close()
                moveTo(13.05f, 9.79f)
                lineTo(10.0f, 7.5f)
                verticalLineToRelative(9.0f)
                lineToRelative(3.05f, -2.29f)
                lineTo(16.0f, 12.0f)
                close()
                moveTo(11.0f, 4.07f)
                lineTo(11.0f, 2.05f)
                curveToRelative(-2.01f, 0.2f, -3.84f, 1.0f, -5.32f, 2.21f)
                lineTo(7.1f, 5.69f)
                curveToRelative(1.11f, -0.86f, 2.44f, -1.44f, 3.9f, -1.62f)
                close()
                moveTo(5.69f, 7.1f)
                lineTo(4.26f, 5.68f)
                curveTo(3.05f, 7.16f, 2.25f, 8.99f, 2.05f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(0.18f, -1.46f, 0.76f, -2.79f, 1.62f, -3.9f)
                close()
                moveTo(4.07f, 13.0f)
                lineTo(2.05f, 13.0f)
                curveToRelative(0.2f, 2.01f, 1.0f, 3.84f, 2.21f, 5.32f)
                lineToRelative(1.43f, -1.43f)
                curveToRelative(-0.86f, -1.1f, -1.44f, -2.43f, -1.62f, -3.89f)
                close()
                moveTo(5.68f, 19.74f)
                curveTo(7.16f, 20.95f, 9.0f, 21.75f, 11.0f, 21.95f)
                verticalLineToRelative(-2.02f)
                curveToRelative(-1.46f, -0.18f, -2.79f, -0.76f, -3.9f, -1.62f)
                lineToRelative(-1.42f, 1.43f)
                close()
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, 5.16f, -3.92f, 9.42f, -8.95f, 9.95f)
                verticalLineToRelative(-2.02f)
                curveTo(16.97f, 19.41f, 20.0f, 16.05f, 20.0f, 12.0f)
                reflectiveCurveToRelative(-3.03f, -7.41f, -6.95f, -7.93f)
                lineTo(13.05f, 2.05f)
                curveTo(18.08f, 2.58f, 22.0f, 6.84f, 22.0f, 12.0f)
                close()
            }
        }
        return _slowMotionVideo!!
    }

private var _slowMotionVideo: ImageVector? = null
