/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ExtensionOff: ImageVector
    get() {
        if (_extensionOff != null) {
            return _extensionOff!!
        }
        _extensionOff = materialIcon(name = "Filled.ExtensionOff") {
            materialPath {
                moveTo(19.78f, 22.61f)
                lineToRelative(-1.63f, -1.63f)
                curveTo(18.1f, 20.98f, 18.05f, 21.0f, 18.0f, 21.0f)
                horizontalLineToRelative(-3.8f)
                curveToRelative(0.0f, -2.71f, -2.16f, -3.0f, -2.7f, -3.0f)
                reflectiveCurveToRelative(-2.7f, 0.29f, -2.7f, 3.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineToRelative(-3.8f)
                curveToRelative(2.71f, 0.0f, 3.0f, -2.16f, 3.0f, -2.7f)
                curveToRelative(0.0f, -0.54f, -0.3f, -2.7f, -2.99f, -2.7f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.09f, 0.02f, -0.14f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(20.0f, 17.17f)
                verticalLineTo(15.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                reflectiveCurveTo(21.38f, 10.0f, 20.0f, 10.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(0.0f, -1.38f, -1.12f, -2.5f, -2.5f, -2.5f)
                reflectiveCurveTo(9.0f, 2.62f, 9.0f, 4.0f)
                horizontalLineTo(6.83f)
                lineTo(20.0f, 17.17f)
                close()
            }
        }
        return _extensionOff!!
    }

private var _extensionOff: ImageVector? = null
