/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Engineering: ImageVector
    get() {
        if (_engineering != null) {
            return _engineering!!
        }
        _engineering = materialIcon(name = "Filled.Engineering") {
            materialPath {
                moveTo(9.0f, 15.0f)
                curveToRelative(-2.67f, 0.0f, -8.0f, 1.34f, -8.0f, 4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.0f)
                curveTo(17.0f, 16.34f, 11.67f, 15.0f, 9.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(22.1f, 6.84f)
                curveToRelative(0.01f, -0.11f, 0.02f, -0.22f, 0.02f, -0.34f)
                curveToRelative(0.0f, -0.12f, -0.01f, -0.23f, -0.03f, -0.34f)
                lineToRelative(0.74f, -0.58f)
                curveToRelative(0.07f, -0.05f, 0.08f, -0.15f, 0.04f, -0.22f)
                lineToRelative(-0.7f, -1.21f)
                curveToRelative(-0.04f, -0.08f, -0.14f, -0.1f, -0.21f, -0.08f)
                lineTo(21.1f, 4.42f)
                curveToRelative(-0.18f, -0.14f, -0.38f, -0.25f, -0.59f, -0.34f)
                lineToRelative(-0.13f, -0.93f)
                curveTo(20.36f, 3.06f, 20.29f, 3.0f, 20.2f, 3.0f)
                horizontalLineToRelative(-1.4f)
                curveToRelative(-0.09f, 0.0f, -0.16f, 0.06f, -0.17f, 0.15f)
                lineTo(18.5f, 4.08f)
                curveToRelative(-0.21f, 0.09f, -0.41f, 0.21f, -0.59f, 0.34f)
                lineToRelative(-0.87f, -0.35f)
                curveToRelative(-0.08f, -0.03f, -0.17f, 0.0f, -0.21f, 0.08f)
                lineToRelative(-0.7f, 1.21f)
                curveToRelative(-0.04f, 0.08f, -0.03f, 0.17f, 0.04f, 0.22f)
                lineToRelative(0.74f, 0.58f)
                curveToRelative(-0.02f, 0.11f, -0.03f, 0.23f, -0.03f, 0.34f)
                curveToRelative(0.0f, 0.11f, 0.01f, 0.23f, 0.03f, 0.34f)
                lineToRelative(-0.74f, 0.58f)
                curveToRelative(-0.07f, 0.05f, -0.08f, 0.15f, -0.04f, 0.22f)
                lineToRelative(0.7f, 1.21f)
                curveToRelative(0.04f, 0.08f, 0.14f, 0.1f, 0.21f, 0.08f)
                lineToRelative(0.87f, -0.35f)
                curveToRelative(0.18f, 0.14f, 0.38f, 0.25f, 0.59f, 0.34f)
                lineToRelative(0.13f, 0.93f)
                curveTo(18.64f, 9.94f, 18.71f, 10.0f, 18.8f, 10.0f)
                horizontalLineToRelative(1.4f)
                curveToRelative(0.09f, 0.0f, 0.16f, -0.06f, 0.17f, -0.15f)
                lineToRelative(0.13f, -0.93f)
                curveToRelative(0.21f, -0.09f, 0.41f, -0.21f, 0.59f, -0.34f)
                lineToRelative(0.87f, 0.35f)
                curveToRelative(0.08f, 0.03f, 0.17f, 0.0f, 0.21f, -0.08f)
                lineToRelative(0.7f, -1.21f)
                curveToRelative(0.04f, -0.08f, 0.03f, -0.17f, -0.04f, -0.22f)
                lineTo(22.1f, 6.84f)
                close()
                moveTo(19.5f, 7.75f)
                curveToRelative(-0.69f, 0.0f, -1.25f, -0.56f, -1.25f, -1.25f)
                reflectiveCurveToRelative(0.56f, -1.25f, 1.25f, -1.25f)
                reflectiveCurveToRelative(1.25f, 0.56f, 1.25f, 1.25f)
                reflectiveCurveTo(20.19f, 7.75f, 19.5f, 7.75f)
                close()
            }
            materialPath {
                moveTo(19.92f, 11.68f)
                lineToRelative(-0.5f, -0.87f)
                curveToRelative(-0.03f, -0.06f, -0.1f, -0.08f, -0.15f, -0.06f)
                lineToRelative(-0.62f, 0.25f)
                curveToRelative(-0.13f, -0.1f, -0.27f, -0.18f, -0.42f, -0.24f)
                lineToRelative(-0.09f, -0.66f)
                curveTo(18.12f, 10.04f, 18.06f, 10.0f, 18.0f, 10.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.06f, 0.0f, -0.11f, 0.04f, -0.12f, 0.11f)
                lineToRelative(-0.09f, 0.66f)
                curveToRelative(-0.15f, 0.06f, -0.29f, 0.15f, -0.42f, 0.24f)
                lineToRelative(-0.62f, -0.25f)
                curveToRelative(-0.06f, -0.02f, -0.12f, 0.0f, -0.15f, 0.06f)
                lineToRelative(-0.5f, 0.87f)
                curveToRelative(-0.03f, 0.06f, -0.02f, 0.12f, 0.03f, 0.16f)
                lineToRelative(0.53f, 0.41f)
                curveToRelative(-0.01f, 0.08f, -0.02f, 0.16f, -0.02f, 0.24f)
                curveToRelative(0.0f, 0.08f, 0.01f, 0.17f, 0.02f, 0.24f)
                lineToRelative(-0.53f, 0.41f)
                curveToRelative(-0.05f, 0.04f, -0.06f, 0.11f, -0.03f, 0.16f)
                lineToRelative(0.5f, 0.87f)
                curveToRelative(0.03f, 0.06f, 0.1f, 0.08f, 0.15f, 0.06f)
                lineToRelative(0.62f, -0.25f)
                curveToRelative(0.13f, 0.1f, 0.27f, 0.18f, 0.42f, 0.24f)
                lineToRelative(0.09f, 0.66f)
                curveTo(16.89f, 14.96f, 16.94f, 15.0f, 17.0f, 15.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.06f, 0.0f, 0.12f, -0.04f, 0.12f, -0.11f)
                lineToRelative(0.09f, -0.66f)
                curveToRelative(0.15f, -0.06f, 0.29f, -0.15f, 0.42f, -0.24f)
                lineToRelative(0.62f, 0.25f)
                curveToRelative(0.06f, 0.02f, 0.12f, 0.0f, 0.15f, -0.06f)
                lineToRelative(0.5f, -0.87f)
                curveToRelative(0.03f, -0.06f, 0.02f, -0.12f, -0.03f, -0.16f)
                lineToRelative(-0.52f, -0.41f)
                curveToRelative(0.01f, -0.08f, 0.02f, -0.16f, 0.02f, -0.24f)
                curveToRelative(0.0f, -0.08f, -0.01f, -0.17f, -0.02f, -0.24f)
                lineToRelative(0.53f, -0.41f)
                curveTo(19.93f, 11.81f, 19.94f, 11.74f, 19.92f, 11.68f)
                close()
                moveTo(17.5f, 13.33f)
                curveToRelative(-0.46f, 0.0f, -0.83f, -0.38f, -0.83f, -0.83f)
                curveToRelative(0.0f, -0.46f, 0.38f, -0.83f, 0.83f, -0.83f)
                reflectiveCurveToRelative(0.83f, 0.38f, 0.83f, 0.83f)
                curveTo(18.33f, 12.96f, 17.96f, 13.33f, 17.5f, 13.33f)
                close()
            }
            materialPath {
                moveTo(4.74f, 9.0f)
                horizontalLineToRelative(8.53f)
                curveToRelative(0.27f, 0.0f, 0.49f, -0.22f, 0.49f, -0.49f)
                verticalLineTo(8.49f)
                curveToRelative(0.0f, -0.27f, -0.22f, -0.49f, -0.49f, -0.49f)
                horizontalLineTo(13.0f)
                curveToRelative(0.0f, -1.48f, -0.81f, -2.75f, -2.0f, -3.45f)
                verticalLineTo(5.5f)
                curveTo(11.0f, 5.78f, 10.78f, 6.0f, 10.5f, 6.0f)
                reflectiveCurveTo(10.0f, 5.78f, 10.0f, 5.5f)
                verticalLineTo(4.14f)
                curveTo(9.68f, 4.06f, 9.35f, 4.0f, 9.0f, 4.0f)
                reflectiveCurveTo(8.32f, 4.06f, 8.0f, 4.14f)
                verticalLineTo(5.5f)
                curveTo(8.0f, 5.78f, 7.78f, 6.0f, 7.5f, 6.0f)
                reflectiveCurveTo(7.0f, 5.78f, 7.0f, 5.5f)
                verticalLineTo(4.55f)
                curveTo(5.81f, 5.25f, 5.0f, 6.52f, 5.0f, 8.0f)
                horizontalLineTo(4.74f)
                curveTo(4.47f, 8.0f, 4.25f, 8.22f, 4.25f, 8.49f)
                verticalLineToRelative(0.03f)
                curveTo(4.25f, 8.78f, 4.47f, 9.0f, 4.74f, 9.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 13.0f)
                curveToRelative(1.86f, 0.0f, 3.41f, -1.28f, 3.86f, -3.0f)
                horizontalLineTo(5.14f)
                curveTo(5.59f, 11.72f, 7.14f, 13.0f, 9.0f, 13.0f)
                close()
            }
        }
        return _engineering!!
    }

private var _engineering: ImageVector? = null
