/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CrueltyFree: ImageVector
    get() {
        if (_crueltyFree != null) {
            return _crueltyFree!!
        }
        _crueltyFree = materialIcon(name = "Filled.CrueltyFree") {
            materialPath {
                moveTo(16.84f, 14.52f)
                curveToRelative(-0.26f, -0.19f, -0.62f, -0.63f, -0.79f, -0.84f)
                curveTo(17.24f, 12.01f, 19.0f, 8.87f, 19.0f, 5.0f)
                curveToRelative(0.0f, -1.95f, -0.74f, -3.0f, -2.0f, -3.0f)
                curveToRelative(-1.54f, 0.0f, -3.96f, 2.06f, -5.0f, 5.97f)
                curveTo(10.96f, 4.06f, 8.54f, 2.0f, 7.0f, 2.0f)
                curveTo(5.74f, 2.0f, 5.0f, 3.05f, 5.0f, 5.0f)
                curveToRelative(0.0f, 3.87f, 1.76f, 7.01f, 2.95f, 8.68f)
                curveToRelative(-0.17f, 0.21f, -0.53f, 0.65f, -0.79f, 0.84f)
                curveToRelative(-0.5f, 0.41f, -1.66f, 1.37f, -1.66f, 2.98f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(1.55f, 0.0f, 2.5f, -0.56f, 2.5f, -0.56f)
                reflectiveCurveToRelative(0.95f, 0.56f, 2.5f, 0.56f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveTo(18.5f, 15.89f, 17.34f, 14.93f, 16.84f, 14.52f)
                close()
                moveTo(9.35f, 12.2f)
                curveTo(8.34f, 10.7f, 7.0f, 8.12f, 7.0f, 5.0f)
                curveToRelative(0.0f, -0.49f, 0.06f, -0.8f, 0.12f, -0.97f)
                curveToRelative(0.94f, 0.31f, 3.24f, 2.71f, 3.38f, 7.64f)
                curveTo(10.03f, 11.79f, 9.66f, 11.97f, 9.35f, 12.2f)
                close()
                moveTo(10.5f, 16.75f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.34f, -0.5f, -0.75f)
                curveToRelative(0.0f, -0.41f, 0.22f, -0.75f, 0.5f, -0.75f)
                reflectiveCurveTo(11.0f, 15.59f, 11.0f, 16.0f)
                curveTo(11.0f, 16.41f, 10.78f, 16.75f, 10.5f, 16.75f)
                close()
                moveTo(12.0f, 19.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.72f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.28f, 0.45f, -0.5f, 1.0f, -0.5f)
                reflectiveCurveToRelative(1.0f, 0.22f, 1.0f, 0.5f)
                curveTo(13.0f, 18.78f, 12.55f, 19.5f, 12.0f, 19.5f)
                close()
                moveTo(13.5f, 16.75f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.34f, -0.5f, -0.75f)
                curveToRelative(0.0f, -0.41f, 0.22f, -0.75f, 0.5f, -0.75f)
                reflectiveCurveTo(14.0f, 15.59f, 14.0f, 16.0f)
                curveTo(14.0f, 16.41f, 13.78f, 16.75f, 13.5f, 16.75f)
                close()
                moveTo(13.5f, 11.67f)
                curveToRelative(0.14f, -4.93f, 2.44f, -7.33f, 3.38f, -7.64f)
                curveTo(16.94f, 4.2f, 17.0f, 4.51f, 17.0f, 5.0f)
                curveToRelative(0.0f, 3.12f, -1.34f, 5.7f, -2.35f, 7.2f)
                curveTo(14.34f, 11.97f, 13.97f, 11.79f, 13.5f, 11.67f)
                close()
            }
        }
        return _crueltyFree!!
    }

private var _crueltyFree: ImageVector? = null
