/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CarRepair: ImageVector
    get() {
        if (_carRepair != null) {
            return _carRepair!!
        }
        _carRepair = materialIcon(name = "Filled.CarRepair") {
            materialPath {
                moveTo(16.22f, 12.0f)
                curveToRelative(0.68f, 0.0f, 1.22f, -0.54f, 1.22f, -1.22f)
                curveToRelative(0.0f, -0.67f, -0.54f, -1.22f, -1.22f, -1.22f)
                reflectiveCurveTo(15.0f, 10.11f, 15.0f, 10.78f)
                curveTo(15.0f, 11.46f, 15.55f, 12.0f, 16.22f, 12.0f)
                close()
                moveTo(6.56f, 10.78f)
                curveToRelative(0.0f, 0.67f, 0.54f, 1.22f, 1.22f, 1.22f)
                reflectiveCurveTo(9.0f, 11.46f, 9.0f, 10.78f)
                curveToRelative(0.0f, -0.67f, -0.54f, -1.22f, -1.22f, -1.22f)
                reflectiveCurveTo(6.56f, 10.11f, 6.56f, 10.78f)
                close()
                moveTo(7.61f, 4.0f)
                lineTo(6.28f, 8.0f)
                horizontalLineToRelative(11.43f)
                lineToRelative(-1.33f, -4.0f)
                horizontalLineTo(7.61f)
                close()
                moveTo(16.28f, 3.0f)
                curveToRelative(0.0f, 0.0f, 0.54f, 0.01f, 0.92f, 0.54f)
                curveToRelative(0.02f, 0.02f, 0.03f, 0.04f, 0.05f, 0.07f)
                curveToRelative(0.07f, 0.11f, 0.14f, 0.24f, 0.19f, 0.4f)
                curveTo(17.66f, 4.66f, 19.0f, 8.69f, 19.0f, 8.69f)
                verticalLineToRelative(6.5f)
                curveToRelative(0.0f, 0.45f, -0.35f, 0.81f, -0.78f, 0.81f)
                horizontalLineToRelative(-0.44f)
                curveTo(17.35f, 16.0f, 17.0f, 15.64f, 17.0f, 15.19f)
                verticalLineTo(14.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(1.19f)
                curveTo(7.0f, 15.64f, 6.65f, 16.0f, 6.22f, 16.0f)
                horizontalLineTo(5.78f)
                curveTo(5.35f, 16.0f, 5.0f, 15.64f, 5.0f, 15.19f)
                verticalLineToRelative(-6.5f)
                curveToRelative(0.0f, 0.0f, 1.34f, -4.02f, 1.55f, -4.69f)
                curveToRelative(0.05f, -0.16f, 0.12f, -0.28f, 0.19f, -0.4f)
                curveTo(6.77f, 3.58f, 6.78f, 3.56f, 6.8f, 3.54f)
                curveTo(7.18f, 3.01f, 7.72f, 3.0f, 7.72f, 3.0f)
                horizontalLineTo(16.28f)
                close()
                moveTo(4.0f, 17.01f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(17.01f)
                close()
            }
        }
        return _carRepair!!
    }

private var _carRepair: ImageVector? = null
