/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Biotech: ImageVector
    get() {
        if (_biotech != null) {
            return _biotech!!
        }
        _biotech = materialIcon(name = "Filled.Biotech") {
            materialPath {
                moveTo(7.0f, 19.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                horizontalLineToRelative(-8.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                curveToRelative(0.0f, -1.09f, 0.59f, -2.04f, 1.46f, -2.56f)
                curveTo(8.17f, 9.03f, 8.0f, 8.54f, 8.0f, 8.0f)
                curveToRelative(0.0f, -0.21f, 0.04f, -0.42f, 0.09f, -0.62f)
                curveTo(6.28f, 8.13f, 5.0f, 9.92f, 5.0f, 12.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.0f)
                close()
            }
            materialPath {
                moveTo(10.56f, 5.51f)
                curveTo(11.91f, 5.54f, 13.0f, 6.64f, 13.0f, 8.0f)
                curveToRelative(0.0f, 0.75f, -0.33f, 1.41f, -0.85f, 1.87f)
                lineToRelative(0.59f, 1.62f)
                lineToRelative(0.94f, -0.34f)
                lineToRelative(0.34f, 0.94f)
                lineToRelative(1.88f, -0.68f)
                lineToRelative(-0.34f, -0.94f)
                lineToRelative(0.94f, -0.34f)
                lineTo(13.76f, 2.6f)
                lineToRelative(-0.94f, 0.34f)
                lineTo(12.48f, 2.0f)
                lineTo(10.6f, 2.68f)
                lineToRelative(0.34f, 0.94f)
                lineTo(10.0f, 3.97f)
                lineTo(10.56f, 5.51f)
                close()
            }
            materialPath {
                moveTo(10.5f, 8.0f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _biotech!!
    }

private var _biotech: ImageVector? = null
