/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.BedroomChild: ImageVector
    get() {
        if (_bedroomChild != null) {
            return _bedroomChild!!
        }
        _bedroomChild = materialIcon(name = "Filled.BedroomChild") {
            materialPath {
                moveTo(9.0f, 8.5f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
            materialPath {
                moveTo(15.64f, 12.0f)
                horizontalLineTo(8.37f)
                curveToRelative(-0.48f, 0.0f, -0.87f, 0.39f, -0.87f, 0.87f)
                horizontalLineToRelative(0.01f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(-1.13f)
                curveTo(16.51f, 12.39f, 16.12f, 12.0f, 15.64f, 12.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(18.0f, 17.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-9.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-4.13f)
                curveToRelative(0.0f, -1.0f, 0.62f, -1.85f, 1.5f, -2.2f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(1.67f)
                curveToRelative(0.88f, 0.35f, 1.5f, 1.2f, 1.5f, 2.2f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _bedroomChild!!
    }

private var _bedroomChild: ImageVector? = null
