/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.WbIncandescent: ImageVector
    get() {
        if (_wbIncandescent != null) {
            return _wbIncandescent!!
        }
        _wbIncandescent = materialIcon(name = "TwoTone.WbIncandescent") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.0f, 8.59f)
                lineToRelative(-1.0f, -0.58f)
                verticalLineTo(4.05f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.96f)
                lineToRelative(-1.0f, 0.58f)
                curveToRelative(-1.24f, 0.72f, -2.0f, 2.04f, -2.0f, 3.46f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                curveToRelative(0.0f, -1.42f, -0.77f, -2.74f, -2.0f, -3.46f)
                close()
            }
            materialPath {
                moveTo(3.55f, 19.09f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.79f, -1.8f)
                lineToRelative(-1.41f, -1.41f)
                close()
                moveTo(11.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(1.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                lineTo(1.0f, 13.0f)
                close()
                moveTo(15.0f, 6.86f)
                lineTo(15.0f, 2.05f)
                lineTo(9.0f, 2.05f)
                verticalLineToRelative(4.81f)
                curveTo(7.21f, 7.9f, 6.0f, 9.83f, 6.0f, 12.05f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                curveToRelative(0.0f, -2.22f, -1.21f, -4.15f, -3.0f, -5.19f)
                close()
                moveTo(12.0f, 16.05f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -1.42f, 0.77f, -2.74f, 2.0f, -3.46f)
                lineToRelative(1.0f, -0.58f)
                lineTo(11.0f, 4.05f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.96f)
                lineToRelative(1.0f, 0.58f)
                curveToRelative(1.24f, 0.72f, 2.0f, 2.04f, 2.0f, 3.46f)
                curveToRelative(0.0f, 2.21f, -1.79f, 4.0f, -4.0f, 4.0f)
                close()
                moveTo(20.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
                moveTo(17.24f, 18.71f)
                lineToRelative(1.79f, 1.8f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-1.8f, -1.79f)
                close()
            }
        }
        return _wbIncandescent!!
    }

private var _wbIncandescent: ImageVector? = null
