/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Voicemail: ImageVector
    get() {
        if (_voicemail != null) {
            return _voicemail!!
        }
        _voicemail = materialIcon(name = "TwoTone.Voicemail") {
            materialPath {
                moveTo(18.5f, 6.0f)
                curveTo(15.46f, 6.0f, 13.0f, 8.46f, 13.0f, 11.5f)
                curveToRelative(0.0f, 1.33f, 0.47f, 2.55f, 1.26f, 3.5f)
                lineTo(9.74f, 15.0f)
                curveToRelative(0.79f, -0.95f, 1.26f, -2.17f, 1.26f, -3.5f)
                curveTo(11.0f, 8.46f, 8.54f, 6.0f, 5.5f, 6.0f)
                reflectiveCurveTo(0.0f, 8.46f, 0.0f, 11.5f)
                reflectiveCurveTo(2.46f, 17.0f, 5.5f, 17.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(3.04f, 0.0f, 5.5f, -2.46f, 5.5f, -5.5f)
                reflectiveCurveTo(21.54f, 6.0f, 18.5f, 6.0f)
                close()
                moveTo(5.5f, 15.0f)
                curveTo(3.57f, 15.0f, 2.0f, 13.43f, 2.0f, 11.5f)
                reflectiveCurveTo(3.57f, 8.0f, 5.5f, 8.0f)
                reflectiveCurveTo(9.0f, 9.57f, 9.0f, 11.5f)
                reflectiveCurveTo(7.43f, 15.0f, 5.5f, 15.0f)
                close()
                moveTo(18.5f, 15.0f)
                curveToRelative(-1.93f, 0.0f, -3.5f, -1.57f, -3.5f, -3.5f)
                reflectiveCurveTo(16.57f, 8.0f, 18.5f, 8.0f)
                reflectiveCurveTo(22.0f, 9.57f, 22.0f, 11.5f)
                reflectiveCurveTo(20.43f, 15.0f, 18.5f, 15.0f)
                close()
            }
        }
        return _voicemail!!
    }

private var _voicemail: ImageVector? = null
