/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Tsunami: ImageVector
    get() {
        if (_tsunami != null) {
            return _tsunami!!
        }
        _tsunami = materialIcon(name = "TwoTone.Tsunami") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.04f, 14.0f)
                curveToRelative(0.47f, -0.24f, 0.68f, -0.41f, 1.3f, -0.87f)
                curveToRelative(2.0f, 1.48f, 3.07f, 1.39f, 3.79f, 1.32f)
                curveTo(8.4f, 13.27f, 8.0f, 11.92f, 8.0f, 10.5f)
                curveToRelative(0.0f, -1.67f, 0.54f, -3.21f, 1.47f, -4.46f)
                curveTo(6.41f, 7.52f, 4.3f, 10.46f, 4.04f, 14.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 17.63f)
                curveToRelative(-0.66f, 0.49f, -2.92f, 2.76f, -6.67f, 0.0f)
                curveTo(3.43f, 19.03f, 2.65f, 19.0f, 2.0f, 19.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.16f, 0.0f, 2.3f, -0.32f, 3.33f, -0.93f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveTo(19.7f, 20.68f, 20.84f, 21.0f, 22.0f, 21.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-0.66f, 0.0f, -1.5f, -0.02f, -3.33f, -1.37f)
                curveTo(14.87f, 20.43f, 12.54f, 18.03f, 12.0f, 17.63f)
                close()
            }
            materialPath {
                moveTo(19.33f, 12.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.67f)
                curveTo(17.5f, 10.0f, 16.0f, 8.5f, 16.0f, 6.67f)
                curveToRelative(0.0f, -1.02f, 0.38f, -1.74f, 1.09f, -3.34f)
                curveTo(15.72f, 3.12f, 15.09f, 3.0f, 14.0f, 3.0f)
                curveTo(7.36f, 3.0f, 2.15f, 8.03f, 2.01f, 14.5f)
                curveToRelative(0.0f, 0.0f, -0.01f, 2.0f, -0.01f, 2.0f)
                curveToRelative(1.16f, 0.0f, 2.3f, -0.32f, 3.33f, -0.93f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(1.03f, 0.61f, 2.17f, 0.93f, 3.33f, 0.93f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-0.66f, 0.0f, -1.5f, -0.02f, -3.33f, -1.37f)
                curveToRelative(-3.8f, 2.8f, -6.12f, 0.4f, -6.67f, 0.0f)
                curveToRelative(-0.9f, 0.67f, -0.54f, 0.41f, -0.91f, 0.63f)
                curveTo(10.39f, 12.82f, 10.0f, 11.7f, 10.0f, 10.5f)
                curveToRelative(0.0f, -2.58f, 1.77f, -4.74f, 4.21f, -5.33f)
                curveTo(14.08f, 5.68f, 14.0f, 6.19f, 14.0f, 6.67f)
                curveTo(14.0f, 9.61f, 16.39f, 12.0f, 19.33f, 12.0f)
                close()
                moveTo(9.13f, 14.45f)
                curveToRelative(-0.72f, 0.07f, -1.79f, 0.16f, -3.79f, -1.32f)
                curveToRelative(-0.62f, 0.46f, -0.82f, 0.63f, -1.3f, 0.87f)
                curveToRelative(0.27f, -3.53f, 2.38f, -6.48f, 5.43f, -7.96f)
                curveTo(8.54f, 7.29f, 8.0f, 8.83f, 8.0f, 10.5f)
                curveTo(8.0f, 11.92f, 8.4f, 13.27f, 9.13f, 14.45f)
                close()
            }
        }
        return _tsunami!!
    }

private var _tsunami: ImageVector? = null
