/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ModeEdit: ImageVector
    get() {
        if (_modeEdit != null) {
            return _modeEdit!!
        }
        _modeEdit = materialIcon(name = "TwoTone.ModeEdit") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 18.08f)
                lineToRelative(0.0f, 0.92f)
                lineToRelative(0.92f, 0.0f)
                lineToRelative(9.06f, -9.06f)
                lineToRelative(-0.92f, -0.92f)
                close()
            }
            materialPath {
                moveTo(3.0f, 17.25f)
                lineTo(3.0f, 21.0f)
                lineToRelative(3.75f, 0.0f)
                lineTo(17.81f, 9.94f)
                lineToRelative(-3.75f, -3.75f)
                lineTo(3.0f, 17.25f)
                close()
                moveTo(5.92f, 19.0f)
                lineTo(5.0f, 19.0f)
                lineToRelative(0.0f, -0.92f)
                lineToRelative(9.06f, -9.06f)
                lineToRelative(0.92f, 0.92f)
                lineTo(5.92f, 19.0f)
                close()
            }
            materialPath {
                moveTo(20.71f, 5.63f)
                lineToRelative(-2.34f, -2.34f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-1.83f, 1.83f)
                lineToRelative(3.75f, 3.75f)
                lineToRelative(1.83f, -1.83f)
                curveTo(21.1f, 6.65f, 21.1f, 6.02f, 20.71f, 5.63f)
                close()
            }
        }
        return _modeEdit!!
    }

private var _modeEdit: ImageVector? = null
