/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ExposureNeg1: ImageVector
    get() {
        if (_exposureNeg1 != null) {
            return _exposureNeg1!!
        }
        _exposureNeg1 = materialIcon(name = "TwoTone.ExposureNeg1") {
            materialPath {
                moveTo(19.0f, 18.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-0.3f)
                lineTo(14.0f, 6.7f)
                verticalLineToRelative(1.7f)
                lineToRelative(3.0f, -1.02f)
                verticalLineTo(18.0f)
                close()
                moveTo(4.0f, 11.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                close()
            }
        }
        return _exposureNeg1!!
    }

private var _exposureNeg1: ImageVector? = null
