/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SquareFoot: ImageVector
    get() {
        if (_squareFoot != null) {
            return _squareFoot!!
        }
        _squareFoot = materialIcon(name = "Sharp.SquareFoot") {
            materialPath {
                moveTo(17.66f, 17.66f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(-1.94f, -1.94f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(-1.94f, -1.94f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.06f, -1.06f)
                lineTo(9.7f, 9.7f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.06f, -1.06f)
                lineTo(7.05f, 7.05f)
                lineTo(5.99f, 8.11f)
                lineTo(5.28f, 7.4f)
                lineToRelative(1.06f, -1.06f)
                lineTo(4.0f, 4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(16.0f)
                lineTo(17.66f, 17.66f)
                close()
                moveTo(7.0f, 17.0f)
                verticalLineToRelative(-5.76f)
                lineTo(12.76f, 17.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _squareFoot!!
    }

private var _squareFoot: ImageVector? = null
