/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SettingsInputComposite: ImageVector
    get() {
        if (_settingsInputComposite != null) {
            return _settingsInputComposite!!
        }
        _settingsInputComposite = materialIcon(name = "Sharp.SettingsInputComposite") {
            materialPath {
                moveTo(5.0f, 2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                lineTo(1.0f, 6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                lineTo(7.0f, 6.0f)
                lineTo(5.0f, 6.0f)
                lineTo(5.0f, 2.0f)
                close()
                moveTo(9.0f, 18.82f)
                horizontalLineToRelative(2.0f)
                lineTo(11.0f, 23.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.18f)
                horizontalLineToRelative(2.0f)
                lineTo(15.0f, 14.0f)
                lineTo(9.0f, 14.0f)
                verticalLineToRelative(4.82f)
                close()
                moveTo(1.0f, 18.82f)
                horizontalLineToRelative(2.0f)
                lineTo(3.0f, 23.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.18f)
                horizontalLineToRelative(2.0f)
                lineTo(7.0f, 14.0f)
                lineTo(1.0f, 14.0f)
                verticalLineToRelative(4.82f)
                close()
                moveTo(21.0f, 6.0f)
                lineTo(21.0f, 2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                lineTo(23.0f, 6.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(13.0f, 2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                lineTo(9.0f, 6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                lineTo(15.0f, 6.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(13.0f, 2.0f)
                close()
                moveTo(17.0f, 18.82f)
                horizontalLineToRelative(2.0f)
                lineTo(19.0f, 23.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.18f)
                horizontalLineToRelative(2.0f)
                lineTo(23.0f, 14.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(4.82f)
                close()
            }
        }
        return _settingsInputComposite!!
    }

private var _settingsInputComposite: ImageVector? = null
