/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RollerSkating: ImageVector
    get() {
        if (_rollerSkating != null) {
            return _rollerSkating!!
        }
        _rollerSkating = materialIcon(name = "Sharp.RollerSkating") {
            materialPath {
                moveTo(20.0f, 16.0f)
                lineToRelative(-0.01f, -6.0f)
                lineToRelative(-5.71f, -1.43f)
                curveTo(13.4f, 8.35f, 12.7f, 7.76f, 12.32f, 7.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(3.02f)
                lineTo(12.0f, 5.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(1.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(15.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(5.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(6.66f, 23.0f, 5.0f, 23.0f)
                close()
                moveTo(19.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(20.66f, 23.0f, 19.0f, 23.0f)
                close()
                moveTo(12.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(13.66f, 23.0f, 12.0f, 23.0f)
                close()
            }
        }
        return _rollerSkating!!
    }

private var _rollerSkating: ImageVector? = null
