/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RememberMe: ImageVector
    get() {
        if (_rememberMe != null) {
            return _rememberMe!!
        }
        _rememberMe = materialIcon(name = "Sharp.RememberMe") {
            materialPath {
                moveTo(19.0f, 1.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(22.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(1.0f)
                close()
                moveTo(17.0f, 15.21f)
                curveTo(15.5f, 14.44f, 13.8f, 14.0f, 12.0f, 14.0f)
                reflectiveCurveToRelative(-3.5f, 0.44f, -5.0f, 1.21f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(15.21f)
                close()
            }
            materialPath {
                moveTo(12.0f, 10.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
        }
        return _rememberMe!!
    }

private var _rememberMe: ImageVector? = null
