/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ElderlyWoman: ImageVector
    get() {
        if (_elderlyWoman != null) {
            return _elderlyWoman!!
        }
        _elderlyWoman = materialIcon(name = "Sharp.ElderlyWoman") {
            materialPath {
                moveTo(18.5f, 11.0f)
                curveToRelative(-1.56f, 0.0f, -2.92f, -0.9f, -3.58f, -2.21f)
                lineToRelative(-0.79f, -1.67f)
                lineToRelative(0.0f, 0.0f)
                curveTo(14.12f, 7.1f, 13.63f, 6.0f, 12.34f, 6.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(8.72f, 6.0f, 6.0f, 16.69f, 6.0f, 19.0f)
                horizontalLineToRelative(2.5f)
                lineToRelative(-2.1f, 2.8f)
                lineTo(8.0f, 23.0f)
                lineToRelative(3.0f, -4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.03f)
                lineTo(13.0f, 13.0f)
                lineToRelative(0.49f, -2.71f)
                curveToRelative(0.81f, 1.23f, 2.05f, 2.14f, 3.51f, 2.52f)
                verticalLineToRelative(0.69f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                reflectiveCurveToRelative(0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineTo(23.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(12.5f)
                curveTo(20.0f, 11.67f, 19.33f, 11.0f, 18.5f, 11.0f)
                close()
            }
            materialPath {
                moveTo(11.6f, 2.91f)
                curveToRelative(-0.06f, 0.19f, -0.1f, 0.38f, -0.1f, 0.59f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                curveToRelative(-0.21f, 0.0f, -0.4f, 0.04f, -0.59f, 0.1f)
                curveTo(12.76f, 1.25f, 12.41f, 1.0f, 12.0f, 1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveTo(11.0f, 2.41f, 11.25f, 2.76f, 11.6f, 2.91f)
                close()
            }
        }
        return _elderlyWoman!!
    }

private var _elderlyWoman: ImageVector? = null
