/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WorkspacePremium: ImageVector
    get() {
        if (_workspacePremium != null) {
            return _workspacePremium!!
        }
        _workspacePremium = materialIcon(name = "Rounded.WorkspacePremium") {
            materialPath {
                moveTo(10.92f, 12.75f)
                lineTo(12.0f, 11.93f)
                lineToRelative(1.07f, 0.81f)
                curveToRelative(0.39f, 0.29f, 0.92f, -0.08f, 0.78f, -0.55f)
                lineToRelative(-0.42f, -1.36f)
                lineToRelative(1.2f, -0.95f)
                curveTo(15.0f, 9.6f, 14.79f, 9.0f, 14.31f, 9.0f)
                horizontalLineToRelative(-1.4f)
                lineToRelative(-0.43f, -1.34f)
                curveToRelative(-0.15f, -0.46f, -0.8f, -0.46f, -0.95f, 0.0f)
                lineTo(11.09f, 9.0f)
                horizontalLineTo(9.68f)
                curveTo(9.21f, 9.0f, 9.0f, 9.6f, 9.37f, 9.89f)
                lineToRelative(1.19f, 0.95f)
                lineToRelative(-0.42f, 1.36f)
                curveTo(10.0f, 12.67f, 10.53f, 13.04f, 10.92f, 12.75f)
                close()
                moveTo(6.0f, 21.61f)
                curveToRelative(0.0f, 0.68f, 0.67f, 1.16f, 1.32f, 0.95f)
                lineTo(12.0f, 21.0f)
                lineToRelative(4.68f, 1.56f)
                curveTo(17.33f, 22.78f, 18.0f, 22.3f, 18.0f, 21.61f)
                verticalLineToRelative(-6.33f)
                curveToRelative(1.24f, -1.41f, 2.0f, -3.25f, 2.0f, -5.28f)
                curveToRelative(0.0f, -4.42f, -3.58f, -8.0f, -8.0f, -8.0f)
                reflectiveCurveToRelative(-8.0f, 3.58f, -8.0f, 8.0f)
                curveToRelative(0.0f, 2.03f, 0.76f, 3.87f, 2.0f, 5.28f)
                verticalLineTo(21.61f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, 2.69f, 6.0f, 6.0f)
                reflectiveCurveToRelative(-2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                reflectiveCurveTo(8.69f, 4.0f, 12.0f, 4.0f)
                close()
            }
        }
        return _workspacePremium!!
    }

private var _workspacePremium: ImageVector? = null
