/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WbSunny: ImageVector
    get() {
        if (_wbSunny != null) {
            return _wbSunny!!
        }
        _wbSunny = materialIcon(name = "Rounded.WbSunny") {
            materialPath {
                moveTo(6.05f, 4.14f)
                lineToRelative(-0.39f, -0.39f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.38f, -1.4f, 0.0f)
                lineToRelative(-0.01f, 0.01f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.4f)
                lineToRelative(0.39f, 0.39f)
                curveToRelative(0.39f, 0.39f, 1.01f, 0.39f, 1.4f, 0.0f)
                lineToRelative(0.01f, -0.01f)
                curveToRelative(0.39f, -0.38f, 0.39f, -1.02f, 0.0f, -1.4f)
                close()
                moveTo(3.01f, 10.5f)
                lineTo(1.99f, 10.5f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                lineTo(3.0f, 12.49f)
                curveToRelative(0.56f, 0.01f, 1.0f, -0.43f, 1.0f, -0.98f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.56f, -0.44f, -1.0f, -0.99f, -1.0f)
                close()
                moveTo(12.01f, 0.55f)
                lineTo(12.0f, 0.55f)
                curveToRelative(-0.56f, 0.0f, -1.0f, 0.44f, -1.0f, 0.99f)
                verticalLineToRelative(0.96f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                lineTo(12.0f, 3.49f)
                curveToRelative(0.56f, 0.01f, 1.0f, -0.43f, 1.0f, -0.98f)
                verticalLineToRelative(-0.97f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                close()
                moveTo(19.75f, 3.76f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, -0.01f)
                lineToRelative(-0.39f, 0.39f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.4f)
                lineToRelative(0.01f, 0.01f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.4f, 0.0f)
                lineToRelative(0.39f, -0.39f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.01f, 0.0f, -1.4f)
                close()
                moveTo(17.94f, 18.86f)
                lineToRelative(0.39f, 0.39f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-0.39f, -0.39f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.38f, -1.4f, 0.0f)
                curveToRelative(-0.4f, 0.4f, -0.4f, 1.02f, -0.01f, 1.41f)
                close()
                moveTo(20.0f, 11.49f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                lineTo(22.0f, 12.49f)
                curveToRelative(0.55f, 0.0f, 0.99f, -0.44f, 0.99f, -0.99f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                horizontalLineToRelative(-1.01f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                close()
                moveTo(12.0f, 5.5f)
                curveToRelative(-3.31f, 0.0f, -6.0f, 2.69f, -6.0f, 6.0f)
                reflectiveCurveToRelative(2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveToRelative(-2.69f, -6.0f, -6.0f, -6.0f)
                close()
                moveTo(11.99f, 22.45f)
                lineTo(12.0f, 22.45f)
                curveToRelative(0.55f, 0.0f, 0.99f, -0.44f, 0.99f, -0.99f)
                verticalLineToRelative(-0.96f)
                curveToRelative(0.0f, -0.55f, -0.44f, -0.99f, -0.99f, -0.99f)
                horizontalLineToRelative(-0.01f)
                curveToRelative(-0.55f, 0.0f, -0.99f, 0.44f, -0.99f, 0.99f)
                verticalLineToRelative(0.96f)
                curveToRelative(0.0f, 0.55f, 0.44f, 0.99f, 0.99f, 0.99f)
                close()
                moveTo(4.25f, 19.24f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.39f, -0.39f)
                curveToRelative(0.39f, -0.39f, 0.38f, -1.02f, 0.0f, -1.4f)
                lineToRelative(-0.01f, -0.01f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-0.39f, 0.39f)
                curveToRelative(-0.38f, 0.4f, -0.38f, 1.02f, 0.01f, 1.41f)
                close()
            }
        }
        return _wbSunny!!
    }

private var _wbSunny: ImageVector? = null
